/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apigateway.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.apigateway.model.ImportDocumentationPartsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.BinaryUtils;
import com.amazonaws.util.SdkHttpUtils;
import com.amazonaws.util.StringUtils;

public class ImportDocumentationPartsRequestMarshaller
implements Marshaller<Request<ImportDocumentationPartsRequest>, ImportDocumentationPartsRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public ImportDocumentationPartsRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<ImportDocumentationPartsRequest> marshall(ImportDocumentationPartsRequest importDocumentationPartsRequest) {
        if (importDocumentationPartsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ImportDocumentationPartsRequest> request = new DefaultRequest<ImportDocumentationPartsRequest>(importDocumentationPartsRequest, "AmazonApiGateway");
        request.setHttpMethod(HttpMethodName.PUT);
        String uriResourcePath = "/restapis/{restapi_id}/documentation/parts";
        uriResourcePath = uriResourcePath.replace("{restapi_id}", importDocumentationPartsRequest.getRestApiId() != null ? SdkHttpUtils.urlEncode(StringUtils.fromString(importDocumentationPartsRequest.getRestApiId()), false) : "");
        request.setResourcePath(uriResourcePath);
        if (importDocumentationPartsRequest.getMode() != null) {
            request.addParameter("mode", StringUtils.fromString(importDocumentationPartsRequest.getMode()));
        }
        if (importDocumentationPartsRequest.getFailOnWarnings() != null) {
            request.addParameter("failonwarnings", StringUtils.fromBoolean(importDocumentationPartsRequest.getFailOnWarnings()));
        }
        request.setContent(BinaryUtils.toStream(importDocumentationPartsRequest.getBody()));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        return request;
    }
}

