/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simplesystemsmanagement.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.simplesystemsmanagement.model.ListDocumentVersionsRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class ListDocumentVersionsRequestMarshaller
implements Marshaller<Request<ListDocumentVersionsRequest>, ListDocumentVersionsRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public ListDocumentVersionsRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<ListDocumentVersionsRequest> marshall(ListDocumentVersionsRequest listDocumentVersionsRequest) {
        if (listDocumentVersionsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ListDocumentVersionsRequest> request = new DefaultRequest<ListDocumentVersionsRequest>(listDocumentVersionsRequest, "AWSSimpleSystemsManagement");
        request.addHeader("X-Amz-Target", "AmazonSSM.ListDocumentVersions");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (listDocumentVersionsRequest.getName() != null) {
                jsonGenerator.writeFieldName("Name").writeValue(listDocumentVersionsRequest.getName());
            }
            if (listDocumentVersionsRequest.getMaxResults() != null) {
                jsonGenerator.writeFieldName("MaxResults").writeValue(listDocumentVersionsRequest.getMaxResults());
            }
            if (listDocumentVersionsRequest.getNextToken() != null) {
                jsonGenerator.writeFieldName("NextToken").writeValue(listDocumentVersionsRequest.getNextToken());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

