/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.shield.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.shield.model.AttackDetail;
import com.amazonaws.services.shield.model.Mitigation;
import com.amazonaws.services.shield.model.SubResourceSummary;
import com.amazonaws.services.shield.model.SummarizedCounter;
import com.amazonaws.services.shield.model.transform.MitigationJsonMarshaller;
import com.amazonaws.services.shield.model.transform.SubResourceSummaryJsonMarshaller;
import com.amazonaws.services.shield.model.transform.SummarizedCounterJsonMarshaller;
import java.util.List;

public class AttackDetailJsonMarshaller {
    private static AttackDetailJsonMarshaller instance;

    public void marshall(AttackDetail attackDetail, StructuredJsonGenerator jsonGenerator) {
        if (attackDetail == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            List<Mitigation> list;
            List<SummarizedCounter> attackCountersList;
            List<SubResourceSummary> subResourcesList;
            jsonGenerator.writeStartObject();
            if (attackDetail.getAttackId() != null) {
                jsonGenerator.writeFieldName("AttackId").writeValue(attackDetail.getAttackId());
            }
            if (attackDetail.getResourceArn() != null) {
                jsonGenerator.writeFieldName("ResourceArn").writeValue(attackDetail.getResourceArn());
            }
            if ((subResourcesList = attackDetail.getSubResources()) != null) {
                jsonGenerator.writeFieldName("SubResources");
                jsonGenerator.writeStartArray();
                for (SubResourceSummary subResourceSummary : subResourcesList) {
                    if (subResourceSummary == null) continue;
                    SubResourceSummaryJsonMarshaller.getInstance().marshall(subResourceSummary, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if (attackDetail.getStartTime() != null) {
                jsonGenerator.writeFieldName("StartTime").writeValue(attackDetail.getStartTime());
            }
            if (attackDetail.getEndTime() != null) {
                jsonGenerator.writeFieldName("EndTime").writeValue(attackDetail.getEndTime());
            }
            if ((attackCountersList = attackDetail.getAttackCounters()) != null) {
                jsonGenerator.writeFieldName("AttackCounters");
                jsonGenerator.writeStartArray();
                for (SummarizedCounter attackCountersListValue : attackCountersList) {
                    if (attackCountersListValue == null) continue;
                    SummarizedCounterJsonMarshaller.getInstance().marshall(attackCountersListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if ((list = attackDetail.getMitigations()) != null) {
                jsonGenerator.writeFieldName("Mitigations");
                jsonGenerator.writeStartArray();
                for (Mitigation mitigationsListValue : list) {
                    if (mitigationsListValue == null) continue;
                    MitigationJsonMarshaller.getInstance().marshall(mitigationsListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static AttackDetailJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new AttackDetailJsonMarshaller();
        }
        return instance;
    }
}

