/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.pinpoint.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.pinpoint.model.GetSegmentImportJobsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.SdkHttpUtils;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;

public class GetSegmentImportJobsRequestMarshaller
implements Marshaller<Request<GetSegmentImportJobsRequest>, GetSegmentImportJobsRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public GetSegmentImportJobsRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<GetSegmentImportJobsRequest> marshall(GetSegmentImportJobsRequest getSegmentImportJobsRequest) {
        if (getSegmentImportJobsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<GetSegmentImportJobsRequest> request = new DefaultRequest<GetSegmentImportJobsRequest>(getSegmentImportJobsRequest, "AmazonPinpoint");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/v1/apps/{application-id}/segments/{segment-id}/jobs/import";
        uriResourcePath = uriResourcePath.replace("{application-id}", getSegmentImportJobsRequest.getApplicationId() != null ? SdkHttpUtils.urlEncode(StringUtils.fromString(getSegmentImportJobsRequest.getApplicationId()), false) : "");
        uriResourcePath = uriResourcePath.replace("{segment-id}", getSegmentImportJobsRequest.getSegmentId() != null ? SdkHttpUtils.urlEncode(StringUtils.fromString(getSegmentImportJobsRequest.getSegmentId()), false) : "");
        request.setResourcePath(uriResourcePath);
        if (getSegmentImportJobsRequest.getPageSize() != null) {
            request.addParameter("page-size", StringUtils.fromString(getSegmentImportJobsRequest.getPageSize()));
        }
        if (getSegmentImportJobsRequest.getToken() != null) {
            request.addParameter("token", StringUtils.fromString(getSegmentImportJobsRequest.getToken()));
        }
        request.setContent(new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        return request;
    }
}

