/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lightsail.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.lightsail.model.UpdateDomainEntryRequest;
import com.amazonaws.services.lightsail.model.transform.DomainEntryJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class UpdateDomainEntryRequestMarshaller
implements Marshaller<Request<UpdateDomainEntryRequest>, UpdateDomainEntryRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public UpdateDomainEntryRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<UpdateDomainEntryRequest> marshall(UpdateDomainEntryRequest updateDomainEntryRequest) {
        if (updateDomainEntryRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<UpdateDomainEntryRequest> request = new DefaultRequest<UpdateDomainEntryRequest>(updateDomainEntryRequest, "AmazonLightsail");
        request.addHeader("X-Amz-Target", "Lightsail_20161128.UpdateDomainEntry");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (updateDomainEntryRequest.getDomainName() != null) {
                jsonGenerator.writeFieldName("domainName").writeValue(updateDomainEntryRequest.getDomainName());
            }
            if (updateDomainEntryRequest.getDomainEntry() != null) {
                jsonGenerator.writeFieldName("domainEntry");
                DomainEntryJsonMarshaller.getInstance().marshall(updateDomainEntryRequest.getDomainEntry(), jsonGenerator);
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

