/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lambda.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.lambda.model.CreateFunctionRequest;
import com.amazonaws.services.lambda.model.transform.DeadLetterConfigJsonMarshaller;
import com.amazonaws.services.lambda.model.transform.EnvironmentJsonMarshaller;
import com.amazonaws.services.lambda.model.transform.FunctionCodeJsonMarshaller;
import com.amazonaws.services.lambda.model.transform.VpcConfigJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class CreateFunctionRequestMarshaller
implements Marshaller<Request<CreateFunctionRequest>, CreateFunctionRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public CreateFunctionRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<CreateFunctionRequest> marshall(CreateFunctionRequest createFunctionRequest) {
        if (createFunctionRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateFunctionRequest> request = new DefaultRequest<CreateFunctionRequest>(createFunctionRequest, "AWSLambda");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/2015-03-31/functions";
        request.setResourcePath(uriResourcePath);
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (createFunctionRequest.getFunctionName() != null) {
                jsonGenerator.writeFieldName("FunctionName").writeValue(createFunctionRequest.getFunctionName());
            }
            if (createFunctionRequest.getRuntime() != null) {
                jsonGenerator.writeFieldName("Runtime").writeValue(createFunctionRequest.getRuntime());
            }
            if (createFunctionRequest.getRole() != null) {
                jsonGenerator.writeFieldName("Role").writeValue(createFunctionRequest.getRole());
            }
            if (createFunctionRequest.getHandler() != null) {
                jsonGenerator.writeFieldName("Handler").writeValue(createFunctionRequest.getHandler());
            }
            if (createFunctionRequest.getCode() != null) {
                jsonGenerator.writeFieldName("Code");
                FunctionCodeJsonMarshaller.getInstance().marshall(createFunctionRequest.getCode(), jsonGenerator);
            }
            if (createFunctionRequest.getDescription() != null) {
                jsonGenerator.writeFieldName("Description").writeValue(createFunctionRequest.getDescription());
            }
            if (createFunctionRequest.getTimeout() != null) {
                jsonGenerator.writeFieldName("Timeout").writeValue(createFunctionRequest.getTimeout());
            }
            if (createFunctionRequest.getMemorySize() != null) {
                jsonGenerator.writeFieldName("MemorySize").writeValue(createFunctionRequest.getMemorySize());
            }
            if (createFunctionRequest.getPublish() != null) {
                jsonGenerator.writeFieldName("Publish").writeValue(createFunctionRequest.getPublish());
            }
            if (createFunctionRequest.getVpcConfig() != null) {
                jsonGenerator.writeFieldName("VpcConfig");
                VpcConfigJsonMarshaller.getInstance().marshall(createFunctionRequest.getVpcConfig(), jsonGenerator);
            }
            if (createFunctionRequest.getDeadLetterConfig() != null) {
                jsonGenerator.writeFieldName("DeadLetterConfig");
                DeadLetterConfigJsonMarshaller.getInstance().marshall(createFunctionRequest.getDeadLetterConfig(), jsonGenerator);
            }
            if (createFunctionRequest.getEnvironment() != null) {
                jsonGenerator.writeFieldName("Environment");
                EnvironmentJsonMarshaller.getInstance().marshall(createFunctionRequest.getEnvironment(), jsonGenerator);
            }
            if (createFunctionRequest.getKMSKeyArn() != null) {
                jsonGenerator.writeFieldName("KMSKeyArn").writeValue(createFunctionRequest.getKMSKeyArn());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", this.protocolFactory.getContentType());
            }
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

