/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kms.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.kms.model.CreateKeyRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class CreateKeyRequestMarshaller
implements Marshaller<Request<CreateKeyRequest>, CreateKeyRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public CreateKeyRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<CreateKeyRequest> marshall(CreateKeyRequest createKeyRequest) {
        if (createKeyRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateKeyRequest> request = new DefaultRequest<CreateKeyRequest>(createKeyRequest, "AWSKMS");
        request.addHeader("X-Amz-Target", "TrentService.CreateKey");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (createKeyRequest.getPolicy() != null) {
                jsonGenerator.writeFieldName("Policy").writeValue(createKeyRequest.getPolicy());
            }
            if (createKeyRequest.getDescription() != null) {
                jsonGenerator.writeFieldName("Description").writeValue(createKeyRequest.getDescription());
            }
            if (createKeyRequest.getKeyUsage() != null) {
                jsonGenerator.writeFieldName("KeyUsage").writeValue(createKeyRequest.getKeyUsage());
            }
            if (createKeyRequest.getOrigin() != null) {
                jsonGenerator.writeFieldName("Origin").writeValue(createKeyRequest.getOrigin());
            }
            if (createKeyRequest.getBypassPolicyLockoutSafetyCheck() != null) {
                jsonGenerator.writeFieldName("BypassPolicyLockoutSafetyCheck").writeValue(createKeyRequest.getBypassPolicyLockoutSafetyCheck());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

