/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.gamelift.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.gamelift.model.GetInstanceAccessRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class GetInstanceAccessRequestMarshaller
implements Marshaller<Request<GetInstanceAccessRequest>, GetInstanceAccessRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public GetInstanceAccessRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<GetInstanceAccessRequest> marshall(GetInstanceAccessRequest getInstanceAccessRequest) {
        if (getInstanceAccessRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<GetInstanceAccessRequest> request = new DefaultRequest<GetInstanceAccessRequest>(getInstanceAccessRequest, "AmazonGameLift");
        request.addHeader("X-Amz-Target", "GameLift.GetInstanceAccess");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (getInstanceAccessRequest.getFleetId() != null) {
                jsonGenerator.writeFieldName("FleetId").writeValue(getInstanceAccessRequest.getFleetId());
            }
            if (getInstanceAccessRequest.getInstanceId() != null) {
                jsonGenerator.writeFieldName("InstanceId").writeValue(getInstanceAccessRequest.getInstanceId());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

