/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.Request;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.DryRunSupportedRequest;
import com.amazonaws.services.ec2.model.Filter;
import com.amazonaws.services.ec2.model.OfferingClassType;
import com.amazonaws.services.ec2.model.OfferingTypeValues;
import com.amazonaws.services.ec2.model.transform.DescribeReservedInstancesRequestMarshaller;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class DescribeReservedInstancesRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable,
DryRunSupportedRequest<DescribeReservedInstancesRequest> {
    private SdkInternalList<String> reservedInstancesIds;
    private SdkInternalList<Filter> filters;
    private String offeringType;
    private String offeringClass;

    public List<String> getReservedInstancesIds() {
        if (this.reservedInstancesIds == null) {
            this.reservedInstancesIds = new SdkInternalList();
        }
        return this.reservedInstancesIds;
    }

    public void setReservedInstancesIds(Collection<String> reservedInstancesIds) {
        if (reservedInstancesIds == null) {
            this.reservedInstancesIds = null;
            return;
        }
        this.reservedInstancesIds = new SdkInternalList<String>(reservedInstancesIds);
    }

    public DescribeReservedInstancesRequest withReservedInstancesIds(String ... reservedInstancesIds) {
        if (this.reservedInstancesIds == null) {
            this.setReservedInstancesIds(new SdkInternalList<String>(reservedInstancesIds.length));
        }
        for (String ele : reservedInstancesIds) {
            this.reservedInstancesIds.add(ele);
        }
        return this;
    }

    public DescribeReservedInstancesRequest withReservedInstancesIds(Collection<String> reservedInstancesIds) {
        this.setReservedInstancesIds(reservedInstancesIds);
        return this;
    }

    public List<Filter> getFilters() {
        if (this.filters == null) {
            this.filters = new SdkInternalList();
        }
        return this.filters;
    }

    public void setFilters(Collection<Filter> filters) {
        if (filters == null) {
            this.filters = null;
            return;
        }
        this.filters = new SdkInternalList<Filter>(filters);
    }

    public DescribeReservedInstancesRequest withFilters(Filter ... filters) {
        if (this.filters == null) {
            this.setFilters(new SdkInternalList<Filter>(filters.length));
        }
        for (Filter ele : filters) {
            this.filters.add(ele);
        }
        return this;
    }

    public DescribeReservedInstancesRequest withFilters(Collection<Filter> filters) {
        this.setFilters(filters);
        return this;
    }

    public void setOfferingType(String offeringType) {
        this.offeringType = offeringType;
    }

    public String getOfferingType() {
        return this.offeringType;
    }

    public DescribeReservedInstancesRequest withOfferingType(String offeringType) {
        this.setOfferingType(offeringType);
        return this;
    }

    public void setOfferingType(OfferingTypeValues offeringType) {
        this.offeringType = offeringType.toString();
    }

    public DescribeReservedInstancesRequest withOfferingType(OfferingTypeValues offeringType) {
        this.setOfferingType(offeringType);
        return this;
    }

    public void setOfferingClass(String offeringClass) {
        this.offeringClass = offeringClass;
    }

    public String getOfferingClass() {
        return this.offeringClass;
    }

    public DescribeReservedInstancesRequest withOfferingClass(String offeringClass) {
        this.setOfferingClass(offeringClass);
        return this;
    }

    public void setOfferingClass(OfferingClassType offeringClass) {
        this.offeringClass = offeringClass.toString();
    }

    public DescribeReservedInstancesRequest withOfferingClass(OfferingClassType offeringClass) {
        this.setOfferingClass(offeringClass);
        return this;
    }

    @Override
    public Request<DescribeReservedInstancesRequest> getDryRunRequest() {
        Request<DescribeReservedInstancesRequest> request = new DescribeReservedInstancesRequestMarshaller().marshall(this);
        request.addParameter("DryRun", Boolean.toString(true));
        return request;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getReservedInstancesIds() != null) {
            sb.append("ReservedInstancesIds: " + this.getReservedInstancesIds() + ",");
        }
        if (this.getFilters() != null) {
            sb.append("Filters: " + this.getFilters() + ",");
        }
        if (this.getOfferingType() != null) {
            sb.append("OfferingType: " + this.getOfferingType() + ",");
        }
        if (this.getOfferingClass() != null) {
            sb.append("OfferingClass: " + this.getOfferingClass());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeReservedInstancesRequest)) {
            return false;
        }
        DescribeReservedInstancesRequest other = (DescribeReservedInstancesRequest)obj;
        if (other.getReservedInstancesIds() == null ^ this.getReservedInstancesIds() == null) {
            return false;
        }
        if (other.getReservedInstancesIds() != null && !other.getReservedInstancesIds().equals(this.getReservedInstancesIds())) {
            return false;
        }
        if (other.getFilters() == null ^ this.getFilters() == null) {
            return false;
        }
        if (other.getFilters() != null && !other.getFilters().equals(this.getFilters())) {
            return false;
        }
        if (other.getOfferingType() == null ^ this.getOfferingType() == null) {
            return false;
        }
        if (other.getOfferingType() != null && !other.getOfferingType().equals(this.getOfferingType())) {
            return false;
        }
        if (other.getOfferingClass() == null ^ this.getOfferingClass() == null) {
            return false;
        }
        return other.getOfferingClass() == null || other.getOfferingClass().equals(this.getOfferingClass());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getReservedInstancesIds() == null ? 0 : this.getReservedInstancesIds().hashCode());
        hashCode = 31 * hashCode + (this.getFilters() == null ? 0 : this.getFilters().hashCode());
        hashCode = 31 * hashCode + (this.getOfferingType() == null ? 0 : this.getOfferingType().hashCode());
        hashCode = 31 * hashCode + (this.getOfferingClass() == null ? 0 : this.getOfferingClass().hashCode());
        return hashCode;
    }

    @Override
    public DescribeReservedInstancesRequest clone() {
        return (DescribeReservedInstancesRequest)super.clone();
    }
}

