/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.budgets.model;

import com.amazonaws.services.budgets.model.Notification;
import com.amazonaws.services.budgets.model.Subscriber;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class NotificationWithSubscribers
implements Serializable,
Cloneable {
    private Notification notification;
    private List<Subscriber> subscribers;

    public void setNotification(Notification notification) {
        this.notification = notification;
    }

    public Notification getNotification() {
        return this.notification;
    }

    public NotificationWithSubscribers withNotification(Notification notification) {
        this.setNotification(notification);
        return this;
    }

    public List<Subscriber> getSubscribers() {
        return this.subscribers;
    }

    public void setSubscribers(Collection<Subscriber> subscribers) {
        if (subscribers == null) {
            this.subscribers = null;
            return;
        }
        this.subscribers = new ArrayList<Subscriber>(subscribers);
    }

    public NotificationWithSubscribers withSubscribers(Subscriber ... subscribers) {
        if (this.subscribers == null) {
            this.setSubscribers(new ArrayList<Subscriber>(subscribers.length));
        }
        for (Subscriber ele : subscribers) {
            this.subscribers.add(ele);
        }
        return this;
    }

    public NotificationWithSubscribers withSubscribers(Collection<Subscriber> subscribers) {
        this.setSubscribers(subscribers);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getNotification() != null) {
            sb.append("Notification: " + this.getNotification() + ",");
        }
        if (this.getSubscribers() != null) {
            sb.append("Subscribers: " + this.getSubscribers());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NotificationWithSubscribers)) {
            return false;
        }
        NotificationWithSubscribers other = (NotificationWithSubscribers)obj;
        if (other.getNotification() == null ^ this.getNotification() == null) {
            return false;
        }
        if (other.getNotification() != null && !other.getNotification().equals(this.getNotification())) {
            return false;
        }
        if (other.getSubscribers() == null ^ this.getSubscribers() == null) {
            return false;
        }
        return other.getSubscribers() == null || other.getSubscribers().equals(this.getSubscribers());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getNotification() == null ? 0 : this.getNotification().hashCode());
        hashCode = 31 * hashCode + (this.getSubscribers() == null ? 0 : this.getSubscribers().hashCode());
        return hashCode;
    }

    public NotificationWithSubscribers clone() {
        try {
            return (NotificationWithSubscribers)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

