/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.budgets.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.budgets.model.Notification;
import com.amazonaws.services.budgets.model.Subscriber;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CreateNotificationRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String accountId;
    private String budgetName;
    private Notification notification;
    private List<Subscriber> subscribers;

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public String getAccountId() {
        return this.accountId;
    }

    public CreateNotificationRequest withAccountId(String accountId) {
        this.setAccountId(accountId);
        return this;
    }

    public void setBudgetName(String budgetName) {
        this.budgetName = budgetName;
    }

    public String getBudgetName() {
        return this.budgetName;
    }

    public CreateNotificationRequest withBudgetName(String budgetName) {
        this.setBudgetName(budgetName);
        return this;
    }

    public void setNotification(Notification notification) {
        this.notification = notification;
    }

    public Notification getNotification() {
        return this.notification;
    }

    public CreateNotificationRequest withNotification(Notification notification) {
        this.setNotification(notification);
        return this;
    }

    public List<Subscriber> getSubscribers() {
        return this.subscribers;
    }

    public void setSubscribers(Collection<Subscriber> subscribers) {
        if (subscribers == null) {
            this.subscribers = null;
            return;
        }
        this.subscribers = new ArrayList<Subscriber>(subscribers);
    }

    public CreateNotificationRequest withSubscribers(Subscriber ... subscribers) {
        if (this.subscribers == null) {
            this.setSubscribers(new ArrayList<Subscriber>(subscribers.length));
        }
        for (Subscriber ele : subscribers) {
            this.subscribers.add(ele);
        }
        return this;
    }

    public CreateNotificationRequest withSubscribers(Collection<Subscriber> subscribers) {
        this.setSubscribers(subscribers);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAccountId() != null) {
            sb.append("AccountId: " + this.getAccountId() + ",");
        }
        if (this.getBudgetName() != null) {
            sb.append("BudgetName: " + this.getBudgetName() + ",");
        }
        if (this.getNotification() != null) {
            sb.append("Notification: " + this.getNotification() + ",");
        }
        if (this.getSubscribers() != null) {
            sb.append("Subscribers: " + this.getSubscribers());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateNotificationRequest)) {
            return false;
        }
        CreateNotificationRequest other = (CreateNotificationRequest)obj;
        if (other.getAccountId() == null ^ this.getAccountId() == null) {
            return false;
        }
        if (other.getAccountId() != null && !other.getAccountId().equals(this.getAccountId())) {
            return false;
        }
        if (other.getBudgetName() == null ^ this.getBudgetName() == null) {
            return false;
        }
        if (other.getBudgetName() != null && !other.getBudgetName().equals(this.getBudgetName())) {
            return false;
        }
        if (other.getNotification() == null ^ this.getNotification() == null) {
            return false;
        }
        if (other.getNotification() != null && !other.getNotification().equals(this.getNotification())) {
            return false;
        }
        if (other.getSubscribers() == null ^ this.getSubscribers() == null) {
            return false;
        }
        return other.getSubscribers() == null || other.getSubscribers().equals(this.getSubscribers());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAccountId() == null ? 0 : this.getAccountId().hashCode());
        hashCode = 31 * hashCode + (this.getBudgetName() == null ? 0 : this.getBudgetName().hashCode());
        hashCode = 31 * hashCode + (this.getNotification() == null ? 0 : this.getNotification().hashCode());
        hashCode = 31 * hashCode + (this.getSubscribers() == null ? 0 : this.getSubscribers().hashCode());
        return hashCode;
    }

    @Override
    public CreateNotificationRequest clone() {
        return (CreateNotificationRequest)super.clone();
    }
}

