/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.appstream.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.appstream.model.UpdateFleetRequest;
import com.amazonaws.services.appstream.model.transform.ComputeCapacityJsonMarshaller;
import com.amazonaws.services.appstream.model.transform.VpcConfigJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class UpdateFleetRequestMarshaller
implements Marshaller<Request<UpdateFleetRequest>, UpdateFleetRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public UpdateFleetRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<UpdateFleetRequest> marshall(UpdateFleetRequest updateFleetRequest) {
        if (updateFleetRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<UpdateFleetRequest> request = new DefaultRequest<UpdateFleetRequest>(updateFleetRequest, "AmazonAppStream");
        request.addHeader("X-Amz-Target", "PhotonAdminProxyService.UpdateFleet");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (updateFleetRequest.getImageName() != null) {
                jsonGenerator.writeFieldName("ImageName").writeValue(updateFleetRequest.getImageName());
            }
            if (updateFleetRequest.getName() != null) {
                jsonGenerator.writeFieldName("Name").writeValue(updateFleetRequest.getName());
            }
            if (updateFleetRequest.getInstanceType() != null) {
                jsonGenerator.writeFieldName("InstanceType").writeValue(updateFleetRequest.getInstanceType());
            }
            if (updateFleetRequest.getComputeCapacity() != null) {
                jsonGenerator.writeFieldName("ComputeCapacity");
                ComputeCapacityJsonMarshaller.getInstance().marshall(updateFleetRequest.getComputeCapacity(), jsonGenerator);
            }
            if (updateFleetRequest.getVpcConfig() != null) {
                jsonGenerator.writeFieldName("VpcConfig");
                VpcConfigJsonMarshaller.getInstance().marshall(updateFleetRequest.getVpcConfig(), jsonGenerator);
            }
            if (updateFleetRequest.getMaxUserDurationInSeconds() != null) {
                jsonGenerator.writeFieldName("MaxUserDurationInSeconds").writeValue(updateFleetRequest.getMaxUserDurationInSeconds());
            }
            if (updateFleetRequest.getDisconnectTimeoutInSeconds() != null) {
                jsonGenerator.writeFieldName("DisconnectTimeoutInSeconds").writeValue(updateFleetRequest.getDisconnectTimeoutInSeconds());
            }
            if (updateFleetRequest.getDeleteVpcConfig() != null) {
                jsonGenerator.writeFieldName("DeleteVpcConfig").writeValue(updateFleetRequest.getDeleteVpcConfig());
            }
            if (updateFleetRequest.getDescription() != null) {
                jsonGenerator.writeFieldName("Description").writeValue(updateFleetRequest.getDescription());
            }
            if (updateFleetRequest.getDisplayName() != null) {
                jsonGenerator.writeFieldName("DisplayName").writeValue(updateFleetRequest.getDisplayName());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

