/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apigateway.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.apigateway.model.CreateDocumentationPartRequest;
import com.amazonaws.services.apigateway.model.transform.DocumentationPartLocationJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.SdkHttpUtils;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;

public class CreateDocumentationPartRequestMarshaller
implements Marshaller<Request<CreateDocumentationPartRequest>, CreateDocumentationPartRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public CreateDocumentationPartRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<CreateDocumentationPartRequest> marshall(CreateDocumentationPartRequest createDocumentationPartRequest) {
        if (createDocumentationPartRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateDocumentationPartRequest> request = new DefaultRequest<CreateDocumentationPartRequest>(createDocumentationPartRequest, "AmazonApiGateway");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/restapis/{restapi_id}/documentation/parts";
        uriResourcePath = uriResourcePath.replace("{restapi_id}", createDocumentationPartRequest.getRestApiId() != null ? SdkHttpUtils.urlEncode(StringUtils.fromString(createDocumentationPartRequest.getRestApiId()), false) : "");
        request.setResourcePath(uriResourcePath);
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (createDocumentationPartRequest.getLocation() != null) {
                jsonGenerator.writeFieldName("location");
                DocumentationPartLocationJsonMarshaller.getInstance().marshall(createDocumentationPartRequest.getLocation(), jsonGenerator);
            }
            if (createDocumentationPartRequest.getProperties() != null) {
                jsonGenerator.writeFieldName("properties").writeValue(createDocumentationPartRequest.getProperties());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", this.protocolFactory.getContentType());
            }
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

