/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.support.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.support.model.Attachment;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class AddAttachmentsToSetRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String attachmentSetId;
    private SdkInternalList<Attachment> attachments;

    public void setAttachmentSetId(String attachmentSetId) {
        this.attachmentSetId = attachmentSetId;
    }

    public String getAttachmentSetId() {
        return this.attachmentSetId;
    }

    public AddAttachmentsToSetRequest withAttachmentSetId(String attachmentSetId) {
        this.setAttachmentSetId(attachmentSetId);
        return this;
    }

    public List<Attachment> getAttachments() {
        if (this.attachments == null) {
            this.attachments = new SdkInternalList();
        }
        return this.attachments;
    }

    public void setAttachments(Collection<Attachment> attachments) {
        if (attachments == null) {
            this.attachments = null;
            return;
        }
        this.attachments = new SdkInternalList<Attachment>(attachments);
    }

    public AddAttachmentsToSetRequest withAttachments(Attachment ... attachments) {
        if (this.attachments == null) {
            this.setAttachments(new SdkInternalList<Attachment>(attachments.length));
        }
        for (Attachment ele : attachments) {
            this.attachments.add(ele);
        }
        return this;
    }

    public AddAttachmentsToSetRequest withAttachments(Collection<Attachment> attachments) {
        this.setAttachments(attachments);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAttachmentSetId() != null) {
            sb.append("AttachmentSetId: " + this.getAttachmentSetId() + ",");
        }
        if (this.getAttachments() != null) {
            sb.append("Attachments: " + this.getAttachments());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddAttachmentsToSetRequest)) {
            return false;
        }
        AddAttachmentsToSetRequest other = (AddAttachmentsToSetRequest)obj;
        if (other.getAttachmentSetId() == null ^ this.getAttachmentSetId() == null) {
            return false;
        }
        if (other.getAttachmentSetId() != null && !other.getAttachmentSetId().equals(this.getAttachmentSetId())) {
            return false;
        }
        if (other.getAttachments() == null ^ this.getAttachments() == null) {
            return false;
        }
        return other.getAttachments() == null || other.getAttachments().equals(this.getAttachments());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAttachmentSetId() == null ? 0 : this.getAttachmentSetId().hashCode());
        hashCode = 31 * hashCode + (this.getAttachments() == null ? 0 : this.getAttachments().hashCode());
        return hashCode;
    }

    @Override
    public AddAttachmentsToSetRequest clone() {
        return (AddAttachmentsToSetRequest)super.clone();
    }
}

