/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.servicecatalog.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.servicecatalog.model.SearchProductsAsAdminRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.util.List;
import java.util.Map;

public class SearchProductsAsAdminRequestMarshaller
implements Marshaller<Request<SearchProductsAsAdminRequest>, SearchProductsAsAdminRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public SearchProductsAsAdminRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<SearchProductsAsAdminRequest> marshall(SearchProductsAsAdminRequest searchProductsAsAdminRequest) {
        if (searchProductsAsAdminRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<SearchProductsAsAdminRequest> request = new DefaultRequest<SearchProductsAsAdminRequest>(searchProductsAsAdminRequest, "AWSServiceCatalog");
        request.addHeader("X-Amz-Target", "AWS242ServiceCatalogService.SearchProductsAsAdmin");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            Map<String, List<String>> filtersMap;
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (searchProductsAsAdminRequest.getAcceptLanguage() != null) {
                jsonGenerator.writeFieldName("AcceptLanguage").writeValue(searchProductsAsAdminRequest.getAcceptLanguage());
            }
            if (searchProductsAsAdminRequest.getPortfolioId() != null) {
                jsonGenerator.writeFieldName("PortfolioId").writeValue(searchProductsAsAdminRequest.getPortfolioId());
            }
            if ((filtersMap = searchProductsAsAdminRequest.getFilters()) != null) {
                jsonGenerator.writeFieldName("Filters");
                jsonGenerator.writeStartObject();
                for (Map.Entry<String, List<String>> filtersMapValue : filtersMap.entrySet()) {
                    if (filtersMapValue.getValue() == null) continue;
                    jsonGenerator.writeFieldName(filtersMapValue.getKey());
                    jsonGenerator.writeStartArray();
                    for (String filtersMapValueList : filtersMapValue.getValue()) {
                        if (filtersMapValueList == null) continue;
                        jsonGenerator.writeValue(filtersMapValueList);
                    }
                    jsonGenerator.writeEndArray();
                }
                jsonGenerator.writeEndObject();
            }
            if (searchProductsAsAdminRequest.getSortBy() != null) {
                jsonGenerator.writeFieldName("SortBy").writeValue(searchProductsAsAdminRequest.getSortBy());
            }
            if (searchProductsAsAdminRequest.getSortOrder() != null) {
                jsonGenerator.writeFieldName("SortOrder").writeValue(searchProductsAsAdminRequest.getSortOrder());
            }
            if (searchProductsAsAdminRequest.getPageToken() != null) {
                jsonGenerator.writeFieldName("PageToken").writeValue(searchProductsAsAdminRequest.getPageToken());
            }
            if (searchProductsAsAdminRequest.getPageSize() != null) {
                jsonGenerator.writeFieldName("PageSize").writeValue(searchProductsAsAdminRequest.getPageSize());
            }
            if (searchProductsAsAdminRequest.getProductSource() != null) {
                jsonGenerator.writeFieldName("ProductSource").writeValue(searchProductsAsAdminRequest.getProductSource());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

