/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.iot.model.DescribeThingTypeRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.SdkHttpUtils;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;

public class DescribeThingTypeRequestMarshaller
implements Marshaller<Request<DescribeThingTypeRequest>, DescribeThingTypeRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public DescribeThingTypeRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<DescribeThingTypeRequest> marshall(DescribeThingTypeRequest describeThingTypeRequest) {
        if (describeThingTypeRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribeThingTypeRequest> request = new DefaultRequest<DescribeThingTypeRequest>(describeThingTypeRequest, "AWSIot");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/thing-types/{thingTypeName}";
        uriResourcePath = uriResourcePath.replace("{thingTypeName}", describeThingTypeRequest.getThingTypeName() != null ? SdkHttpUtils.urlEncode(StringUtils.fromString(describeThingTypeRequest.getThingTypeName()), false) : "");
        request.setResourcePath(uriResourcePath);
        request.setContent(new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        return request;
    }
}

