/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticmapreduce.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.elasticmapreduce.model.CancelStepsRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class CancelStepsRequestMarshaller
implements Marshaller<Request<CancelStepsRequest>, CancelStepsRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public CancelStepsRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<CancelStepsRequest> marshall(CancelStepsRequest cancelStepsRequest) {
        if (cancelStepsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CancelStepsRequest> request = new DefaultRequest<CancelStepsRequest>(cancelStepsRequest, "AmazonElasticMapReduce");
        request.addHeader("X-Amz-Target", "ElasticMapReduce.CancelSteps");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            SdkInternalList stepIdsList;
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (cancelStepsRequest.getClusterId() != null) {
                jsonGenerator.writeFieldName("ClusterId").writeValue(cancelStepsRequest.getClusterId());
            }
            if (!(stepIdsList = (SdkInternalList)cancelStepsRequest.getStepIds()).isEmpty() || !stepIdsList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("StepIds");
                jsonGenerator.writeStartArray();
                for (String stepIdsListValue : stepIdsList) {
                    if (stepIdsListValue == null) continue;
                    jsonGenerator.writeValue(stepIdsListValue);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

