/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.databasemigrationservice.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.databasemigrationservice.model.DescribeReplicationTasksRequest;
import com.amazonaws.services.databasemigrationservice.model.Filter;
import com.amazonaws.services.databasemigrationservice.model.transform.FilterJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.util.List;

public class DescribeReplicationTasksRequestMarshaller
implements Marshaller<Request<DescribeReplicationTasksRequest>, DescribeReplicationTasksRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public DescribeReplicationTasksRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<DescribeReplicationTasksRequest> marshall(DescribeReplicationTasksRequest describeReplicationTasksRequest) {
        if (describeReplicationTasksRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribeReplicationTasksRequest> request = new DefaultRequest<DescribeReplicationTasksRequest>(describeReplicationTasksRequest, "AWSDatabaseMigrationService");
        request.addHeader("X-Amz-Target", "AmazonDMSv20160101.DescribeReplicationTasks");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            List<Filter> filtersList = describeReplicationTasksRequest.getFilters();
            if (filtersList != null) {
                jsonGenerator.writeFieldName("Filters");
                jsonGenerator.writeStartArray();
                for (Filter filtersListValue : filtersList) {
                    if (filtersListValue == null) continue;
                    FilterJsonMarshaller.getInstance().marshall(filtersListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if (describeReplicationTasksRequest.getMaxRecords() != null) {
                jsonGenerator.writeFieldName("MaxRecords").writeValue(describeReplicationTasksRequest.getMaxRecords());
            }
            if (describeReplicationTasksRequest.getMarker() != null) {
                jsonGenerator.writeFieldName("Marker").writeValue(describeReplicationTasksRequest.getMarker());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

