/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lambda.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.lambda.model.UpdateEventSourceMappingRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.SdkHttpUtils;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;

public class UpdateEventSourceMappingRequestMarshaller
implements Marshaller<Request<UpdateEventSourceMappingRequest>, UpdateEventSourceMappingRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public UpdateEventSourceMappingRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<UpdateEventSourceMappingRequest> marshall(UpdateEventSourceMappingRequest updateEventSourceMappingRequest) {
        if (updateEventSourceMappingRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<UpdateEventSourceMappingRequest> request = new DefaultRequest<UpdateEventSourceMappingRequest>(updateEventSourceMappingRequest, "AWSLambda");
        request.setHttpMethod(HttpMethodName.PUT);
        String uriResourcePath = "/2015-03-31/event-source-mappings/{UUID}";
        uriResourcePath = uriResourcePath.replace("{UUID}", updateEventSourceMappingRequest.getUUID() != null ? SdkHttpUtils.urlEncode(StringUtils.fromString(updateEventSourceMappingRequest.getUUID()), false) : "");
        request.setResourcePath(uriResourcePath);
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (updateEventSourceMappingRequest.getFunctionName() != null) {
                jsonGenerator.writeFieldName("FunctionName").writeValue(updateEventSourceMappingRequest.getFunctionName());
            }
            if (updateEventSourceMappingRequest.getEnabled() != null) {
                jsonGenerator.writeFieldName("Enabled").writeValue(updateEventSourceMappingRequest.getEnabled());
            }
            if (updateEventSourceMappingRequest.getBatchSize() != null) {
                jsonGenerator.writeFieldName("BatchSize").writeValue(updateEventSourceMappingRequest.getBatchSize());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", this.protocolFactory.getContentType());
            }
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

