/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codepipeline.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.codepipeline.model.Artifact;
import com.amazonaws.services.codepipeline.model.transform.ArtifactLocationJsonMarshaller;

public class ArtifactJsonMarshaller {
    private static ArtifactJsonMarshaller instance;

    public void marshall(Artifact artifact, StructuredJsonGenerator jsonGenerator) {
        if (artifact == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (artifact.getName() != null) {
                jsonGenerator.writeFieldName("name").writeValue(artifact.getName());
            }
            if (artifact.getRevision() != null) {
                jsonGenerator.writeFieldName("revision").writeValue(artifact.getRevision());
            }
            if (artifact.getLocation() != null) {
                jsonGenerator.writeFieldName("location");
                ArtifactLocationJsonMarshaller.getInstance().marshall(artifact.getLocation(), jsonGenerator);
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static ArtifactJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new ArtifactJsonMarshaller();
        }
        return instance;
    }
}

