/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudwatchevents.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.cloudwatchevents.model.ListRulesRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class ListRulesRequestMarshaller
implements Marshaller<Request<ListRulesRequest>, ListRulesRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public ListRulesRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<ListRulesRequest> marshall(ListRulesRequest listRulesRequest) {
        if (listRulesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ListRulesRequest> request = new DefaultRequest<ListRulesRequest>(listRulesRequest, "AmazonCloudWatchEvents");
        request.addHeader("X-Amz-Target", "AWSEvents.ListRules");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (listRulesRequest.getNamePrefix() != null) {
                jsonGenerator.writeFieldName("NamePrefix").writeValue(listRulesRequest.getNamePrefix());
            }
            if (listRulesRequest.getNextToken() != null) {
                jsonGenerator.writeFieldName("NextToken").writeValue(listRulesRequest.getNextToken());
            }
            if (listRulesRequest.getLimit() != null) {
                jsonGenerator.writeFieldName("Limit").writeValue(listRulesRequest.getLimit());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

