/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.dynamodbv2.model.Stream;

public class StreamJsonMarshaller {
    private static StreamJsonMarshaller instance;

    public void marshall(Stream stream, StructuredJsonGenerator jsonGenerator) {
        if (stream == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (stream.getStreamArn() != null) {
                jsonGenerator.writeFieldName("StreamArn").writeValue(stream.getStreamArn());
            }
            if (stream.getTableName() != null) {
                jsonGenerator.writeFieldName("TableName").writeValue(stream.getTableName());
            }
            if (stream.getStreamLabel() != null) {
                jsonGenerator.writeFieldName("StreamLabel").writeValue(stream.getStreamLabel());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static StreamJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new StreamJsonMarshaller();
        }
        return instance;
    }
}

