/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitosync.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.cognitosync.model.RecordPatch;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class UpdateRecordsRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String identityPoolId;
    private String identityId;
    private String datasetName;
    private String deviceId;
    private SdkInternalList<RecordPatch> recordPatches;
    private String syncSessionToken;
    private String clientContext;

    public void setIdentityPoolId(String identityPoolId) {
        this.identityPoolId = identityPoolId;
    }

    public String getIdentityPoolId() {
        return this.identityPoolId;
    }

    public UpdateRecordsRequest withIdentityPoolId(String identityPoolId) {
        this.setIdentityPoolId(identityPoolId);
        return this;
    }

    public void setIdentityId(String identityId) {
        this.identityId = identityId;
    }

    public String getIdentityId() {
        return this.identityId;
    }

    public UpdateRecordsRequest withIdentityId(String identityId) {
        this.setIdentityId(identityId);
        return this;
    }

    public void setDatasetName(String datasetName) {
        this.datasetName = datasetName;
    }

    public String getDatasetName() {
        return this.datasetName;
    }

    public UpdateRecordsRequest withDatasetName(String datasetName) {
        this.setDatasetName(datasetName);
        return this;
    }

    public void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
    }

    public String getDeviceId() {
        return this.deviceId;
    }

    public UpdateRecordsRequest withDeviceId(String deviceId) {
        this.setDeviceId(deviceId);
        return this;
    }

    public List<RecordPatch> getRecordPatches() {
        if (this.recordPatches == null) {
            this.recordPatches = new SdkInternalList();
        }
        return this.recordPatches;
    }

    public void setRecordPatches(Collection<RecordPatch> recordPatches) {
        if (recordPatches == null) {
            this.recordPatches = null;
            return;
        }
        this.recordPatches = new SdkInternalList<RecordPatch>(recordPatches);
    }

    public UpdateRecordsRequest withRecordPatches(RecordPatch ... recordPatches) {
        if (this.recordPatches == null) {
            this.setRecordPatches(new SdkInternalList<RecordPatch>(recordPatches.length));
        }
        for (RecordPatch ele : recordPatches) {
            this.recordPatches.add(ele);
        }
        return this;
    }

    public UpdateRecordsRequest withRecordPatches(Collection<RecordPatch> recordPatches) {
        this.setRecordPatches(recordPatches);
        return this;
    }

    public void setSyncSessionToken(String syncSessionToken) {
        this.syncSessionToken = syncSessionToken;
    }

    public String getSyncSessionToken() {
        return this.syncSessionToken;
    }

    public UpdateRecordsRequest withSyncSessionToken(String syncSessionToken) {
        this.setSyncSessionToken(syncSessionToken);
        return this;
    }

    public void setClientContext(String clientContext) {
        this.clientContext = clientContext;
    }

    public String getClientContext() {
        return this.clientContext;
    }

    public UpdateRecordsRequest withClientContext(String clientContext) {
        this.setClientContext(clientContext);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getIdentityPoolId() != null) {
            sb.append("IdentityPoolId: " + this.getIdentityPoolId() + ",");
        }
        if (this.getIdentityId() != null) {
            sb.append("IdentityId: " + this.getIdentityId() + ",");
        }
        if (this.getDatasetName() != null) {
            sb.append("DatasetName: " + this.getDatasetName() + ",");
        }
        if (this.getDeviceId() != null) {
            sb.append("DeviceId: " + this.getDeviceId() + ",");
        }
        if (this.getRecordPatches() != null) {
            sb.append("RecordPatches: " + this.getRecordPatches() + ",");
        }
        if (this.getSyncSessionToken() != null) {
            sb.append("SyncSessionToken: " + this.getSyncSessionToken() + ",");
        }
        if (this.getClientContext() != null) {
            sb.append("ClientContext: " + this.getClientContext());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateRecordsRequest)) {
            return false;
        }
        UpdateRecordsRequest other = (UpdateRecordsRequest)obj;
        if (other.getIdentityPoolId() == null ^ this.getIdentityPoolId() == null) {
            return false;
        }
        if (other.getIdentityPoolId() != null && !other.getIdentityPoolId().equals(this.getIdentityPoolId())) {
            return false;
        }
        if (other.getIdentityId() == null ^ this.getIdentityId() == null) {
            return false;
        }
        if (other.getIdentityId() != null && !other.getIdentityId().equals(this.getIdentityId())) {
            return false;
        }
        if (other.getDatasetName() == null ^ this.getDatasetName() == null) {
            return false;
        }
        if (other.getDatasetName() != null && !other.getDatasetName().equals(this.getDatasetName())) {
            return false;
        }
        if (other.getDeviceId() == null ^ this.getDeviceId() == null) {
            return false;
        }
        if (other.getDeviceId() != null && !other.getDeviceId().equals(this.getDeviceId())) {
            return false;
        }
        if (other.getRecordPatches() == null ^ this.getRecordPatches() == null) {
            return false;
        }
        if (other.getRecordPatches() != null && !other.getRecordPatches().equals(this.getRecordPatches())) {
            return false;
        }
        if (other.getSyncSessionToken() == null ^ this.getSyncSessionToken() == null) {
            return false;
        }
        if (other.getSyncSessionToken() != null && !other.getSyncSessionToken().equals(this.getSyncSessionToken())) {
            return false;
        }
        if (other.getClientContext() == null ^ this.getClientContext() == null) {
            return false;
        }
        return other.getClientContext() == null || other.getClientContext().equals(this.getClientContext());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getIdentityPoolId() == null ? 0 : this.getIdentityPoolId().hashCode());
        hashCode = 31 * hashCode + (this.getIdentityId() == null ? 0 : this.getIdentityId().hashCode());
        hashCode = 31 * hashCode + (this.getDatasetName() == null ? 0 : this.getDatasetName().hashCode());
        hashCode = 31 * hashCode + (this.getDeviceId() == null ? 0 : this.getDeviceId().hashCode());
        hashCode = 31 * hashCode + (this.getRecordPatches() == null ? 0 : this.getRecordPatches().hashCode());
        hashCode = 31 * hashCode + (this.getSyncSessionToken() == null ? 0 : this.getSyncSessionToken().hashCode());
        hashCode = 31 * hashCode + (this.getClientContext() == null ? 0 : this.getClientContext().hashCode());
        return hashCode;
    }

    @Override
    public UpdateRecordsRequest clone() {
        return (UpdateRecordsRequest)super.clone();
    }
}

