/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.logs.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.logs.model.CreateExportTaskRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class CreateExportTaskRequestMarshaller
implements Marshaller<Request<CreateExportTaskRequest>, CreateExportTaskRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public CreateExportTaskRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<CreateExportTaskRequest> marshall(CreateExportTaskRequest createExportTaskRequest) {
        if (createExportTaskRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateExportTaskRequest> request = new DefaultRequest<CreateExportTaskRequest>(createExportTaskRequest, "AWSLogs");
        request.addHeader("X-Amz-Target", "Logs_20140328.CreateExportTask");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (createExportTaskRequest.getTaskName() != null) {
                jsonGenerator.writeFieldName("taskName").writeValue(createExportTaskRequest.getTaskName());
            }
            if (createExportTaskRequest.getLogGroupName() != null) {
                jsonGenerator.writeFieldName("logGroupName").writeValue(createExportTaskRequest.getLogGroupName());
            }
            if (createExportTaskRequest.getLogStreamNamePrefix() != null) {
                jsonGenerator.writeFieldName("logStreamNamePrefix").writeValue(createExportTaskRequest.getLogStreamNamePrefix());
            }
            if (createExportTaskRequest.getFrom() != null) {
                jsonGenerator.writeFieldName("from").writeValue(createExportTaskRequest.getFrom());
            }
            if (createExportTaskRequest.getTo() != null) {
                jsonGenerator.writeFieldName("to").writeValue(createExportTaskRequest.getTo());
            }
            if (createExportTaskRequest.getDestination() != null) {
                jsonGenerator.writeFieldName("destination").writeValue(createExportTaskRequest.getDestination());
            }
            if (createExportTaskRequest.getDestinationPrefix() != null) {
                jsonGenerator.writeFieldName("destinationPrefix").writeValue(createExportTaskRequest.getDestinationPrefix());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

