/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.gamelift.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.gamelift.model.CreateBuildRequest;
import com.amazonaws.services.gamelift.model.transform.S3LocationJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class CreateBuildRequestMarshaller
implements Marshaller<Request<CreateBuildRequest>, CreateBuildRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public CreateBuildRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<CreateBuildRequest> marshall(CreateBuildRequest createBuildRequest) {
        if (createBuildRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateBuildRequest> request = new DefaultRequest<CreateBuildRequest>(createBuildRequest, "AmazonGameLift");
        request.addHeader("X-Amz-Target", "GameLift.CreateBuild");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (createBuildRequest.getName() != null) {
                jsonGenerator.writeFieldName("Name").writeValue(createBuildRequest.getName());
            }
            if (createBuildRequest.getVersion() != null) {
                jsonGenerator.writeFieldName("Version").writeValue(createBuildRequest.getVersion());
            }
            if (createBuildRequest.getStorageLocation() != null) {
                jsonGenerator.writeFieldName("StorageLocation");
                S3LocationJsonMarshaller.getInstance().marshall(createBuildRequest.getStorageLocation(), jsonGenerator);
            }
            if (createBuildRequest.getOperatingSystem() != null) {
                jsonGenerator.writeFieldName("OperatingSystem").writeValue(createBuildRequest.getOperatingSystem());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

