/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codedeploy.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.codedeploy.model.BatchGetOnPremisesInstancesRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class BatchGetOnPremisesInstancesRequestMarshaller
implements Marshaller<Request<BatchGetOnPremisesInstancesRequest>, BatchGetOnPremisesInstancesRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public BatchGetOnPremisesInstancesRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<BatchGetOnPremisesInstancesRequest> marshall(BatchGetOnPremisesInstancesRequest batchGetOnPremisesInstancesRequest) {
        if (batchGetOnPremisesInstancesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<BatchGetOnPremisesInstancesRequest> request = new DefaultRequest<BatchGetOnPremisesInstancesRequest>(batchGetOnPremisesInstancesRequest, "AmazonCodeDeploy");
        request.addHeader("X-Amz-Target", "CodeDeploy_20141006.BatchGetOnPremisesInstances");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            SdkInternalList instanceNamesList = (SdkInternalList)batchGetOnPremisesInstancesRequest.getInstanceNames();
            if (!instanceNamesList.isEmpty() || !instanceNamesList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("instanceNames");
                jsonGenerator.writeStartArray();
                for (String instanceNamesListValue : instanceNamesList) {
                    if (instanceNamesListValue == null) continue;
                    jsonGenerator.writeValue(instanceNamesListValue);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

