/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.iot.model.SetDefaultPolicyVersionRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.SdkHttpUtils;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;

public class SetDefaultPolicyVersionRequestMarshaller
implements Marshaller<Request<SetDefaultPolicyVersionRequest>, SetDefaultPolicyVersionRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public SetDefaultPolicyVersionRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<SetDefaultPolicyVersionRequest> marshall(SetDefaultPolicyVersionRequest setDefaultPolicyVersionRequest) {
        if (setDefaultPolicyVersionRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<SetDefaultPolicyVersionRequest> request = new DefaultRequest<SetDefaultPolicyVersionRequest>(setDefaultPolicyVersionRequest, "AWSIot");
        request.setHttpMethod(HttpMethodName.PATCH);
        String uriResourcePath = "/policies/{policyName}/version/{policyVersionId}";
        uriResourcePath = uriResourcePath.replace("{policyName}", setDefaultPolicyVersionRequest.getPolicyName() != null ? SdkHttpUtils.urlEncode(StringUtils.fromString(setDefaultPolicyVersionRequest.getPolicyName()), false) : "");
        uriResourcePath = uriResourcePath.replace("{policyVersionId}", setDefaultPolicyVersionRequest.getPolicyVersionId() != null ? SdkHttpUtils.urlEncode(StringUtils.fromString(setDefaultPolicyVersionRequest.getPolicyVersionId()), false) : "");
        request.setResourcePath(uriResourcePath);
        request.setContent(new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        return request;
    }
}

