/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.gamelift.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.gamelift.model.SearchGameSessionsRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class SearchGameSessionsRequestMarshaller
implements Marshaller<Request<SearchGameSessionsRequest>, SearchGameSessionsRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public SearchGameSessionsRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<SearchGameSessionsRequest> marshall(SearchGameSessionsRequest searchGameSessionsRequest) {
        if (searchGameSessionsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<SearchGameSessionsRequest> request = new DefaultRequest<SearchGameSessionsRequest>(searchGameSessionsRequest, "AmazonGameLift");
        request.addHeader("X-Amz-Target", "GameLift.SearchGameSessions");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (searchGameSessionsRequest.getFleetId() != null) {
                jsonGenerator.writeFieldName("FleetId").writeValue(searchGameSessionsRequest.getFleetId());
            }
            if (searchGameSessionsRequest.getAliasId() != null) {
                jsonGenerator.writeFieldName("AliasId").writeValue(searchGameSessionsRequest.getAliasId());
            }
            if (searchGameSessionsRequest.getFilterExpression() != null) {
                jsonGenerator.writeFieldName("FilterExpression").writeValue(searchGameSessionsRequest.getFilterExpression());
            }
            if (searchGameSessionsRequest.getSortExpression() != null) {
                jsonGenerator.writeFieldName("SortExpression").writeValue(searchGameSessionsRequest.getSortExpression());
            }
            if (searchGameSessionsRequest.getLimit() != null) {
                jsonGenerator.writeFieldName("Limit").writeValue(searchGameSessionsRequest.getLimit());
            }
            if (searchGameSessionsRequest.getNextToken() != null) {
                jsonGenerator.writeFieldName("NextToken").writeValue(searchGameSessionsRequest.getNextToken());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

