/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.ec2.model.RestoreAddressToClassicRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class RestoreAddressToClassicRequestMarshaller
implements Marshaller<Request<RestoreAddressToClassicRequest>, RestoreAddressToClassicRequest> {
    @Override
    public Request<RestoreAddressToClassicRequest> marshall(RestoreAddressToClassicRequest restoreAddressToClassicRequest) {
        if (restoreAddressToClassicRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<RestoreAddressToClassicRequest> request = new DefaultRequest<RestoreAddressToClassicRequest>(restoreAddressToClassicRequest, "AmazonEC2");
        request.addParameter("Action", "RestoreAddressToClassic");
        request.addParameter("Version", "2016-09-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (restoreAddressToClassicRequest.getPublicIp() != null) {
            request.addParameter("PublicIp", StringUtils.fromString(restoreAddressToClassicRequest.getPublicIp()));
        }
        return request;
    }
}

