/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.ec2.model.CreateKeyPairRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class CreateKeyPairRequestMarshaller
implements Marshaller<Request<CreateKeyPairRequest>, CreateKeyPairRequest> {
    @Override
    public Request<CreateKeyPairRequest> marshall(CreateKeyPairRequest createKeyPairRequest) {
        if (createKeyPairRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateKeyPairRequest> request = new DefaultRequest<CreateKeyPairRequest>(createKeyPairRequest, "AmazonEC2");
        request.addParameter("Action", "CreateKeyPair");
        request.addParameter("Version", "2016-09-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (createKeyPairRequest.getKeyName() != null) {
            request.addParameter("KeyName", StringUtils.fromString(createKeyPairRequest.getKeyName()));
        }
        return request;
    }
}

