/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.dynamodbv2.model.KeySchemaElement;

public class KeySchemaElementJsonMarshaller {
    private static KeySchemaElementJsonMarshaller instance;

    public void marshall(KeySchemaElement keySchemaElement, StructuredJsonGenerator jsonGenerator) {
        if (keySchemaElement == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (keySchemaElement.getAttributeName() != null) {
                jsonGenerator.writeFieldName("AttributeName").writeValue(keySchemaElement.getAttributeName());
            }
            if (keySchemaElement.getKeyType() != null) {
                jsonGenerator.writeFieldName("KeyType").writeValue(keySchemaElement.getKeyType());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static KeySchemaElementJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new KeySchemaElementJsonMarshaller();
        }
        return instance;
    }
}

