/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.directconnect;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.internal.StaticCredentialsProvider;
import com.amazonaws.metrics.RequestMetricCollector;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.directconnect.AmazonDirectConnect;
import com.amazonaws.services.directconnect.model.AllocateConnectionOnInterconnectRequest;
import com.amazonaws.services.directconnect.model.AllocateConnectionOnInterconnectResult;
import com.amazonaws.services.directconnect.model.AllocatePrivateVirtualInterfaceRequest;
import com.amazonaws.services.directconnect.model.AllocatePrivateVirtualInterfaceResult;
import com.amazonaws.services.directconnect.model.AllocatePublicVirtualInterfaceRequest;
import com.amazonaws.services.directconnect.model.AllocatePublicVirtualInterfaceResult;
import com.amazonaws.services.directconnect.model.AmazonDirectConnectException;
import com.amazonaws.services.directconnect.model.ConfirmConnectionRequest;
import com.amazonaws.services.directconnect.model.ConfirmConnectionResult;
import com.amazonaws.services.directconnect.model.ConfirmPrivateVirtualInterfaceRequest;
import com.amazonaws.services.directconnect.model.ConfirmPrivateVirtualInterfaceResult;
import com.amazonaws.services.directconnect.model.ConfirmPublicVirtualInterfaceRequest;
import com.amazonaws.services.directconnect.model.ConfirmPublicVirtualInterfaceResult;
import com.amazonaws.services.directconnect.model.CreateConnectionRequest;
import com.amazonaws.services.directconnect.model.CreateConnectionResult;
import com.amazonaws.services.directconnect.model.CreateInterconnectRequest;
import com.amazonaws.services.directconnect.model.CreateInterconnectResult;
import com.amazonaws.services.directconnect.model.CreatePrivateVirtualInterfaceRequest;
import com.amazonaws.services.directconnect.model.CreatePrivateVirtualInterfaceResult;
import com.amazonaws.services.directconnect.model.CreatePublicVirtualInterfaceRequest;
import com.amazonaws.services.directconnect.model.CreatePublicVirtualInterfaceResult;
import com.amazonaws.services.directconnect.model.DeleteConnectionRequest;
import com.amazonaws.services.directconnect.model.DeleteConnectionResult;
import com.amazonaws.services.directconnect.model.DeleteInterconnectRequest;
import com.amazonaws.services.directconnect.model.DeleteInterconnectResult;
import com.amazonaws.services.directconnect.model.DeleteVirtualInterfaceRequest;
import com.amazonaws.services.directconnect.model.DeleteVirtualInterfaceResult;
import com.amazonaws.services.directconnect.model.DescribeConnectionLoaRequest;
import com.amazonaws.services.directconnect.model.DescribeConnectionLoaResult;
import com.amazonaws.services.directconnect.model.DescribeConnectionsOnInterconnectRequest;
import com.amazonaws.services.directconnect.model.DescribeConnectionsOnInterconnectResult;
import com.amazonaws.services.directconnect.model.DescribeConnectionsRequest;
import com.amazonaws.services.directconnect.model.DescribeConnectionsResult;
import com.amazonaws.services.directconnect.model.DescribeInterconnectLoaRequest;
import com.amazonaws.services.directconnect.model.DescribeInterconnectLoaResult;
import com.amazonaws.services.directconnect.model.DescribeInterconnectsRequest;
import com.amazonaws.services.directconnect.model.DescribeInterconnectsResult;
import com.amazonaws.services.directconnect.model.DescribeLocationsRequest;
import com.amazonaws.services.directconnect.model.DescribeLocationsResult;
import com.amazonaws.services.directconnect.model.DescribeVirtualGatewaysRequest;
import com.amazonaws.services.directconnect.model.DescribeVirtualGatewaysResult;
import com.amazonaws.services.directconnect.model.DescribeVirtualInterfacesRequest;
import com.amazonaws.services.directconnect.model.DescribeVirtualInterfacesResult;
import com.amazonaws.services.directconnect.model.DirectConnectClientException;
import com.amazonaws.services.directconnect.model.DirectConnectServerException;
import com.amazonaws.services.directconnect.model.transform.AllocateConnectionOnInterconnectRequestMarshaller;
import com.amazonaws.services.directconnect.model.transform.AllocateConnectionOnInterconnectResultJsonUnmarshaller;
import com.amazonaws.services.directconnect.model.transform.AllocatePrivateVirtualInterfaceRequestMarshaller;
import com.amazonaws.services.directconnect.model.transform.AllocatePrivateVirtualInterfaceResultJsonUnmarshaller;
import com.amazonaws.services.directconnect.model.transform.AllocatePublicVirtualInterfaceRequestMarshaller;
import com.amazonaws.services.directconnect.model.transform.AllocatePublicVirtualInterfaceResultJsonUnmarshaller;
import com.amazonaws.services.directconnect.model.transform.ConfirmConnectionRequestMarshaller;
import com.amazonaws.services.directconnect.model.transform.ConfirmConnectionResultJsonUnmarshaller;
import com.amazonaws.services.directconnect.model.transform.ConfirmPrivateVirtualInterfaceRequestMarshaller;
import com.amazonaws.services.directconnect.model.transform.ConfirmPrivateVirtualInterfaceResultJsonUnmarshaller;
import com.amazonaws.services.directconnect.model.transform.ConfirmPublicVirtualInterfaceRequestMarshaller;
import com.amazonaws.services.directconnect.model.transform.ConfirmPublicVirtualInterfaceResultJsonUnmarshaller;
import com.amazonaws.services.directconnect.model.transform.CreateConnectionRequestMarshaller;
import com.amazonaws.services.directconnect.model.transform.CreateConnectionResultJsonUnmarshaller;
import com.amazonaws.services.directconnect.model.transform.CreateInterconnectRequestMarshaller;
import com.amazonaws.services.directconnect.model.transform.CreateInterconnectResultJsonUnmarshaller;
import com.amazonaws.services.directconnect.model.transform.CreatePrivateVirtualInterfaceRequestMarshaller;
import com.amazonaws.services.directconnect.model.transform.CreatePrivateVirtualInterfaceResultJsonUnmarshaller;
import com.amazonaws.services.directconnect.model.transform.CreatePublicVirtualInterfaceRequestMarshaller;
import com.amazonaws.services.directconnect.model.transform.CreatePublicVirtualInterfaceResultJsonUnmarshaller;
import com.amazonaws.services.directconnect.model.transform.DeleteConnectionRequestMarshaller;
import com.amazonaws.services.directconnect.model.transform.DeleteConnectionResultJsonUnmarshaller;
import com.amazonaws.services.directconnect.model.transform.DeleteInterconnectRequestMarshaller;
import com.amazonaws.services.directconnect.model.transform.DeleteInterconnectResultJsonUnmarshaller;
import com.amazonaws.services.directconnect.model.transform.DeleteVirtualInterfaceRequestMarshaller;
import com.amazonaws.services.directconnect.model.transform.DeleteVirtualInterfaceResultJsonUnmarshaller;
import com.amazonaws.services.directconnect.model.transform.DescribeConnectionLoaRequestMarshaller;
import com.amazonaws.services.directconnect.model.transform.DescribeConnectionLoaResultJsonUnmarshaller;
import com.amazonaws.services.directconnect.model.transform.DescribeConnectionsOnInterconnectRequestMarshaller;
import com.amazonaws.services.directconnect.model.transform.DescribeConnectionsOnInterconnectResultJsonUnmarshaller;
import com.amazonaws.services.directconnect.model.transform.DescribeConnectionsRequestMarshaller;
import com.amazonaws.services.directconnect.model.transform.DescribeConnectionsResultJsonUnmarshaller;
import com.amazonaws.services.directconnect.model.transform.DescribeInterconnectLoaRequestMarshaller;
import com.amazonaws.services.directconnect.model.transform.DescribeInterconnectLoaResultJsonUnmarshaller;
import com.amazonaws.services.directconnect.model.transform.DescribeInterconnectsRequestMarshaller;
import com.amazonaws.services.directconnect.model.transform.DescribeInterconnectsResultJsonUnmarshaller;
import com.amazonaws.services.directconnect.model.transform.DescribeLocationsRequestMarshaller;
import com.amazonaws.services.directconnect.model.transform.DescribeLocationsResultJsonUnmarshaller;
import com.amazonaws.services.directconnect.model.transform.DescribeVirtualGatewaysRequestMarshaller;
import com.amazonaws.services.directconnect.model.transform.DescribeVirtualGatewaysResultJsonUnmarshaller;
import com.amazonaws.services.directconnect.model.transform.DescribeVirtualInterfacesRequestMarshaller;
import com.amazonaws.services.directconnect.model.transform.DescribeVirtualInterfacesResultJsonUnmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AmazonDirectConnectClient
extends AmazonWebServiceClient
implements AmazonDirectConnect {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AmazonDirectConnect.class);
    private static final String DEFAULT_SIGNING_NAME = "directconnect";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("DirectConnectServerException").withModeledClass(DirectConnectServerException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("DirectConnectClientException").withModeledClass(DirectConnectClientException.class)).withBaseServiceExceptionClass(AmazonDirectConnectException.class));

    public AmazonDirectConnectClient() {
        this(new DefaultAWSCredentialsProviderChain(), configFactory.getConfig());
    }

    public AmazonDirectConnectClient(ClientConfiguration clientConfiguration) {
        this(new DefaultAWSCredentialsProviderChain(), clientConfiguration);
    }

    public AmazonDirectConnectClient(AWSCredentials awsCredentials) {
        this(awsCredentials, configFactory.getConfig());
    }

    public AmazonDirectConnectClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.awsCredentialsProvider = new StaticCredentialsProvider(awsCredentials);
        this.init();
    }

    public AmazonDirectConnectClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, configFactory.getConfig());
    }

    public AmazonDirectConnectClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, null);
    }

    public AmazonDirectConnectClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, RequestMetricCollector requestMetricCollector) {
        super(clientConfiguration, requestMetricCollector);
        this.awsCredentialsProvider = awsCredentialsProvider;
        this.init();
    }

    AmazonDirectConnectClient(AwsSyncClientParams clientParams) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix(DEFAULT_SIGNING_NAME);
        this.setEndpoint("https://directconnect.us-east-1.amazonaws.com/");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/directconnect/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/directconnect/request.handler2s"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AllocateConnectionOnInterconnectResult allocateConnectionOnInterconnect(AllocateConnectionOnInterconnectRequest allocateConnectionOnInterconnectRequest) {
        ExecutionContext executionContext = this.createExecutionContext(allocateConnectionOnInterconnectRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<AllocateConnectionOnInterconnectRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new AllocateConnectionOnInterconnectRequestMarshaller(this.protocolFactory).marshall(super.beforeMarshalling(allocateConnectionOnInterconnectRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new AllocateConnectionOnInterconnectResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            AllocateConnectionOnInterconnectResult allocateConnectionOnInterconnectResult = (AllocateConnectionOnInterconnectResult)response.getAwsResponse();
            return allocateConnectionOnInterconnectResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AllocatePrivateVirtualInterfaceResult allocatePrivateVirtualInterface(AllocatePrivateVirtualInterfaceRequest allocatePrivateVirtualInterfaceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(allocatePrivateVirtualInterfaceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<AllocatePrivateVirtualInterfaceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new AllocatePrivateVirtualInterfaceRequestMarshaller(this.protocolFactory).marshall(super.beforeMarshalling(allocatePrivateVirtualInterfaceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new AllocatePrivateVirtualInterfaceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            AllocatePrivateVirtualInterfaceResult allocatePrivateVirtualInterfaceResult = (AllocatePrivateVirtualInterfaceResult)response.getAwsResponse();
            return allocatePrivateVirtualInterfaceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AllocatePublicVirtualInterfaceResult allocatePublicVirtualInterface(AllocatePublicVirtualInterfaceRequest allocatePublicVirtualInterfaceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(allocatePublicVirtualInterfaceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<AllocatePublicVirtualInterfaceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new AllocatePublicVirtualInterfaceRequestMarshaller(this.protocolFactory).marshall(super.beforeMarshalling(allocatePublicVirtualInterfaceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new AllocatePublicVirtualInterfaceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            AllocatePublicVirtualInterfaceResult allocatePublicVirtualInterfaceResult = (AllocatePublicVirtualInterfaceResult)response.getAwsResponse();
            return allocatePublicVirtualInterfaceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConfirmConnectionResult confirmConnection(ConfirmConnectionRequest confirmConnectionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(confirmConnectionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ConfirmConnectionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ConfirmConnectionRequestMarshaller(this.protocolFactory).marshall(super.beforeMarshalling(confirmConnectionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new ConfirmConnectionResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ConfirmConnectionResult confirmConnectionResult = (ConfirmConnectionResult)response.getAwsResponse();
            return confirmConnectionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConfirmPrivateVirtualInterfaceResult confirmPrivateVirtualInterface(ConfirmPrivateVirtualInterfaceRequest confirmPrivateVirtualInterfaceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(confirmPrivateVirtualInterfaceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ConfirmPrivateVirtualInterfaceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ConfirmPrivateVirtualInterfaceRequestMarshaller(this.protocolFactory).marshall(super.beforeMarshalling(confirmPrivateVirtualInterfaceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new ConfirmPrivateVirtualInterfaceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ConfirmPrivateVirtualInterfaceResult confirmPrivateVirtualInterfaceResult = (ConfirmPrivateVirtualInterfaceResult)response.getAwsResponse();
            return confirmPrivateVirtualInterfaceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConfirmPublicVirtualInterfaceResult confirmPublicVirtualInterface(ConfirmPublicVirtualInterfaceRequest confirmPublicVirtualInterfaceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(confirmPublicVirtualInterfaceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ConfirmPublicVirtualInterfaceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ConfirmPublicVirtualInterfaceRequestMarshaller(this.protocolFactory).marshall(super.beforeMarshalling(confirmPublicVirtualInterfaceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new ConfirmPublicVirtualInterfaceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ConfirmPublicVirtualInterfaceResult confirmPublicVirtualInterfaceResult = (ConfirmPublicVirtualInterfaceResult)response.getAwsResponse();
            return confirmPublicVirtualInterfaceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateConnectionResult createConnection(CreateConnectionRequest createConnectionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createConnectionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateConnectionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateConnectionRequestMarshaller(this.protocolFactory).marshall(super.beforeMarshalling(createConnectionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new CreateConnectionResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateConnectionResult createConnectionResult = (CreateConnectionResult)response.getAwsResponse();
            return createConnectionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateInterconnectResult createInterconnect(CreateInterconnectRequest createInterconnectRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createInterconnectRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateInterconnectRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateInterconnectRequestMarshaller(this.protocolFactory).marshall(super.beforeMarshalling(createInterconnectRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new CreateInterconnectResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateInterconnectResult createInterconnectResult = (CreateInterconnectResult)response.getAwsResponse();
            return createInterconnectResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreatePrivateVirtualInterfaceResult createPrivateVirtualInterface(CreatePrivateVirtualInterfaceRequest createPrivateVirtualInterfaceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createPrivateVirtualInterfaceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreatePrivateVirtualInterfaceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreatePrivateVirtualInterfaceRequestMarshaller(this.protocolFactory).marshall(super.beforeMarshalling(createPrivateVirtualInterfaceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new CreatePrivateVirtualInterfaceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreatePrivateVirtualInterfaceResult createPrivateVirtualInterfaceResult = (CreatePrivateVirtualInterfaceResult)response.getAwsResponse();
            return createPrivateVirtualInterfaceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreatePublicVirtualInterfaceResult createPublicVirtualInterface(CreatePublicVirtualInterfaceRequest createPublicVirtualInterfaceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createPublicVirtualInterfaceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreatePublicVirtualInterfaceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreatePublicVirtualInterfaceRequestMarshaller(this.protocolFactory).marshall(super.beforeMarshalling(createPublicVirtualInterfaceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new CreatePublicVirtualInterfaceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreatePublicVirtualInterfaceResult createPublicVirtualInterfaceResult = (CreatePublicVirtualInterfaceResult)response.getAwsResponse();
            return createPublicVirtualInterfaceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteConnectionResult deleteConnection(DeleteConnectionRequest deleteConnectionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteConnectionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteConnectionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteConnectionRequestMarshaller(this.protocolFactory).marshall(super.beforeMarshalling(deleteConnectionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DeleteConnectionResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteConnectionResult deleteConnectionResult = (DeleteConnectionResult)response.getAwsResponse();
            return deleteConnectionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteInterconnectResult deleteInterconnect(DeleteInterconnectRequest deleteInterconnectRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteInterconnectRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteInterconnectRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteInterconnectRequestMarshaller(this.protocolFactory).marshall(super.beforeMarshalling(deleteInterconnectRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DeleteInterconnectResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteInterconnectResult deleteInterconnectResult = (DeleteInterconnectResult)response.getAwsResponse();
            return deleteInterconnectResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteVirtualInterfaceResult deleteVirtualInterface(DeleteVirtualInterfaceRequest deleteVirtualInterfaceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteVirtualInterfaceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteVirtualInterfaceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteVirtualInterfaceRequestMarshaller(this.protocolFactory).marshall(super.beforeMarshalling(deleteVirtualInterfaceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DeleteVirtualInterfaceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteVirtualInterfaceResult deleteVirtualInterfaceResult = (DeleteVirtualInterfaceResult)response.getAwsResponse();
            return deleteVirtualInterfaceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeConnectionLoaResult describeConnectionLoa(DescribeConnectionLoaRequest describeConnectionLoaRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeConnectionLoaRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeConnectionLoaRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeConnectionLoaRequestMarshaller(this.protocolFactory).marshall(super.beforeMarshalling(describeConnectionLoaRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DescribeConnectionLoaResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeConnectionLoaResult describeConnectionLoaResult = (DescribeConnectionLoaResult)response.getAwsResponse();
            return describeConnectionLoaResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeConnectionsResult describeConnections(DescribeConnectionsRequest describeConnectionsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeConnectionsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeConnectionsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeConnectionsRequestMarshaller(this.protocolFactory).marshall(super.beforeMarshalling(describeConnectionsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DescribeConnectionsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeConnectionsResult describeConnectionsResult = (DescribeConnectionsResult)response.getAwsResponse();
            return describeConnectionsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeConnectionsResult describeConnections() {
        return this.describeConnections(new DescribeConnectionsRequest());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeConnectionsOnInterconnectResult describeConnectionsOnInterconnect(DescribeConnectionsOnInterconnectRequest describeConnectionsOnInterconnectRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeConnectionsOnInterconnectRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeConnectionsOnInterconnectRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeConnectionsOnInterconnectRequestMarshaller(this.protocolFactory).marshall(super.beforeMarshalling(describeConnectionsOnInterconnectRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DescribeConnectionsOnInterconnectResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeConnectionsOnInterconnectResult describeConnectionsOnInterconnectResult = (DescribeConnectionsOnInterconnectResult)response.getAwsResponse();
            return describeConnectionsOnInterconnectResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeInterconnectLoaResult describeInterconnectLoa(DescribeInterconnectLoaRequest describeInterconnectLoaRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeInterconnectLoaRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeInterconnectLoaRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeInterconnectLoaRequestMarshaller(this.protocolFactory).marshall(super.beforeMarshalling(describeInterconnectLoaRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DescribeInterconnectLoaResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeInterconnectLoaResult describeInterconnectLoaResult = (DescribeInterconnectLoaResult)response.getAwsResponse();
            return describeInterconnectLoaResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeInterconnectsResult describeInterconnects(DescribeInterconnectsRequest describeInterconnectsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeInterconnectsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeInterconnectsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeInterconnectsRequestMarshaller(this.protocolFactory).marshall(super.beforeMarshalling(describeInterconnectsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DescribeInterconnectsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeInterconnectsResult describeInterconnectsResult = (DescribeInterconnectsResult)response.getAwsResponse();
            return describeInterconnectsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeInterconnectsResult describeInterconnects() {
        return this.describeInterconnects(new DescribeInterconnectsRequest());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeLocationsResult describeLocations(DescribeLocationsRequest describeLocationsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeLocationsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeLocationsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeLocationsRequestMarshaller(this.protocolFactory).marshall(super.beforeMarshalling(describeLocationsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DescribeLocationsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeLocationsResult describeLocationsResult = (DescribeLocationsResult)response.getAwsResponse();
            return describeLocationsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeLocationsResult describeLocations() {
        return this.describeLocations(new DescribeLocationsRequest());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeVirtualGatewaysResult describeVirtualGateways(DescribeVirtualGatewaysRequest describeVirtualGatewaysRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeVirtualGatewaysRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeVirtualGatewaysRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeVirtualGatewaysRequestMarshaller(this.protocolFactory).marshall(super.beforeMarshalling(describeVirtualGatewaysRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DescribeVirtualGatewaysResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeVirtualGatewaysResult describeVirtualGatewaysResult = (DescribeVirtualGatewaysResult)response.getAwsResponse();
            return describeVirtualGatewaysResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeVirtualGatewaysResult describeVirtualGateways() {
        return this.describeVirtualGateways(new DescribeVirtualGatewaysRequest());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeVirtualInterfacesResult describeVirtualInterfaces(DescribeVirtualInterfacesRequest describeVirtualInterfacesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeVirtualInterfacesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeVirtualInterfacesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeVirtualInterfacesRequestMarshaller(this.protocolFactory).marshall(super.beforeMarshalling(describeVirtualInterfacesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), new DescribeVirtualInterfacesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeVirtualInterfacesResult describeVirtualInterfacesResult = (DescribeVirtualInterfacesResult)response.getAwsResponse();
            return describeVirtualInterfacesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeVirtualInterfacesResult describeVirtualInterfaces() {
        return this.describeVirtualInterfaces(new DescribeVirtualInterfacesRequest());
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider(request.getOriginalRequest(), this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        request.setEndpoint(this.endpoint);
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }
}

