/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticloadbalancingv2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.elasticloadbalancingv2.model.DeleteListenerRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DeleteListenerRequestMarshaller
implements Marshaller<Request<DeleteListenerRequest>, DeleteListenerRequest> {
    @Override
    public Request<DeleteListenerRequest> marshall(DeleteListenerRequest deleteListenerRequest) {
        if (deleteListenerRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DeleteListenerRequest> request = new DefaultRequest<DeleteListenerRequest>(deleteListenerRequest, "AmazonElasticLoadBalancing");
        request.addParameter("Action", "DeleteListener");
        request.addParameter("Version", "2015-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (deleteListenerRequest.getListenerArn() != null) {
            request.addParameter("ListenerArn", StringUtils.fromString(deleteListenerRequest.getListenerArn()));
        }
        return request;
    }
}

