/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidp.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.cognitoidp.model.GetDeviceRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class GetDeviceRequestMarshaller
implements Marshaller<Request<GetDeviceRequest>, GetDeviceRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public GetDeviceRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<GetDeviceRequest> marshall(GetDeviceRequest getDeviceRequest) {
        if (getDeviceRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<GetDeviceRequest> request = new DefaultRequest<GetDeviceRequest>(getDeviceRequest, "AWSCognitoIdentityProvider");
        request.addHeader("X-Amz-Target", "AWSCognitoIdentityProviderService.GetDevice");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (getDeviceRequest.getDeviceKey() != null) {
                jsonGenerator.writeFieldName("DeviceKey").writeValue(getDeviceRequest.getDeviceKey());
            }
            if (getDeviceRequest.getAccessToken() != null) {
                jsonGenerator.writeFieldName("AccessToken").writeValue(getDeviceRequest.getAccessToken());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

