/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.snowball;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.snowball.AmazonSnowballAsync;
import com.amazonaws.services.snowball.AmazonSnowballClient;
import com.amazonaws.services.snowball.model.CancelJobRequest;
import com.amazonaws.services.snowball.model.CancelJobResult;
import com.amazonaws.services.snowball.model.CreateAddressRequest;
import com.amazonaws.services.snowball.model.CreateAddressResult;
import com.amazonaws.services.snowball.model.CreateJobRequest;
import com.amazonaws.services.snowball.model.CreateJobResult;
import com.amazonaws.services.snowball.model.DescribeAddressRequest;
import com.amazonaws.services.snowball.model.DescribeAddressResult;
import com.amazonaws.services.snowball.model.DescribeAddressesRequest;
import com.amazonaws.services.snowball.model.DescribeAddressesResult;
import com.amazonaws.services.snowball.model.DescribeJobRequest;
import com.amazonaws.services.snowball.model.DescribeJobResult;
import com.amazonaws.services.snowball.model.GetJobManifestRequest;
import com.amazonaws.services.snowball.model.GetJobManifestResult;
import com.amazonaws.services.snowball.model.GetJobUnlockCodeRequest;
import com.amazonaws.services.snowball.model.GetJobUnlockCodeResult;
import com.amazonaws.services.snowball.model.GetSnowballUsageRequest;
import com.amazonaws.services.snowball.model.GetSnowballUsageResult;
import com.amazonaws.services.snowball.model.ListJobsRequest;
import com.amazonaws.services.snowball.model.ListJobsResult;
import com.amazonaws.services.snowball.model.UpdateJobRequest;
import com.amazonaws.services.snowball.model.UpdateJobResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

@ThreadSafe
public class AmazonSnowballAsyncClient
extends AmazonSnowballClient
implements AmazonSnowballAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public AmazonSnowballAsyncClient() {
        this(new DefaultAWSCredentialsProviderChain());
    }

    public AmazonSnowballAsyncClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain(), clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AmazonSnowballAsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newFixedThreadPool(50));
    }

    public AmazonSnowballAsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        this(awsCredentials, configFactory.getConfig(), executorService);
    }

    public AmazonSnowballAsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    public AmazonSnowballAsyncClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, Executors.newFixedThreadPool(50));
    }

    public AmazonSnowballAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AmazonSnowballAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ExecutorService executorService) {
        this(awsCredentialsProvider, configFactory.getConfig(), executorService);
    }

    public AmazonSnowballAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    AmazonSnowballAsyncClient(AwsAsyncClientParams asyncClientParams) {
        super(asyncClientParams);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<CancelJobResult> cancelJobAsync(CancelJobRequest request) {
        return this.cancelJobAsync(request, null);
    }

    @Override
    public Future<CancelJobResult> cancelJobAsync(final CancelJobRequest request, final AsyncHandler<CancelJobRequest, CancelJobResult> asyncHandler) {
        return this.executorService.submit(new Callable<CancelJobResult>(){

            @Override
            public CancelJobResult call() throws Exception {
                CancelJobResult result;
                try {
                    result = AmazonSnowballAsyncClient.this.cancelJob(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateAddressResult> createAddressAsync(CreateAddressRequest request) {
        return this.createAddressAsync(request, null);
    }

    @Override
    public Future<CreateAddressResult> createAddressAsync(final CreateAddressRequest request, final AsyncHandler<CreateAddressRequest, CreateAddressResult> asyncHandler) {
        return this.executorService.submit(new Callable<CreateAddressResult>(){

            @Override
            public CreateAddressResult call() throws Exception {
                CreateAddressResult result;
                try {
                    result = AmazonSnowballAsyncClient.this.createAddress(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateJobResult> createJobAsync(CreateJobRequest request) {
        return this.createJobAsync(request, null);
    }

    @Override
    public Future<CreateJobResult> createJobAsync(final CreateJobRequest request, final AsyncHandler<CreateJobRequest, CreateJobResult> asyncHandler) {
        return this.executorService.submit(new Callable<CreateJobResult>(){

            @Override
            public CreateJobResult call() throws Exception {
                CreateJobResult result;
                try {
                    result = AmazonSnowballAsyncClient.this.createJob(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeAddressResult> describeAddressAsync(DescribeAddressRequest request) {
        return this.describeAddressAsync(request, null);
    }

    @Override
    public Future<DescribeAddressResult> describeAddressAsync(final DescribeAddressRequest request, final AsyncHandler<DescribeAddressRequest, DescribeAddressResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeAddressResult>(){

            @Override
            public DescribeAddressResult call() throws Exception {
                DescribeAddressResult result;
                try {
                    result = AmazonSnowballAsyncClient.this.describeAddress(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeAddressesResult> describeAddressesAsync(DescribeAddressesRequest request) {
        return this.describeAddressesAsync(request, null);
    }

    @Override
    public Future<DescribeAddressesResult> describeAddressesAsync(final DescribeAddressesRequest request, final AsyncHandler<DescribeAddressesRequest, DescribeAddressesResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeAddressesResult>(){

            @Override
            public DescribeAddressesResult call() throws Exception {
                DescribeAddressesResult result;
                try {
                    result = AmazonSnowballAsyncClient.this.describeAddresses(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeJobResult> describeJobAsync(DescribeJobRequest request) {
        return this.describeJobAsync(request, null);
    }

    @Override
    public Future<DescribeJobResult> describeJobAsync(final DescribeJobRequest request, final AsyncHandler<DescribeJobRequest, DescribeJobResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeJobResult>(){

            @Override
            public DescribeJobResult call() throws Exception {
                DescribeJobResult result;
                try {
                    result = AmazonSnowballAsyncClient.this.describeJob(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetJobManifestResult> getJobManifestAsync(GetJobManifestRequest request) {
        return this.getJobManifestAsync(request, null);
    }

    @Override
    public Future<GetJobManifestResult> getJobManifestAsync(final GetJobManifestRequest request, final AsyncHandler<GetJobManifestRequest, GetJobManifestResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetJobManifestResult>(){

            @Override
            public GetJobManifestResult call() throws Exception {
                GetJobManifestResult result;
                try {
                    result = AmazonSnowballAsyncClient.this.getJobManifest(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetJobUnlockCodeResult> getJobUnlockCodeAsync(GetJobUnlockCodeRequest request) {
        return this.getJobUnlockCodeAsync(request, null);
    }

    @Override
    public Future<GetJobUnlockCodeResult> getJobUnlockCodeAsync(final GetJobUnlockCodeRequest request, final AsyncHandler<GetJobUnlockCodeRequest, GetJobUnlockCodeResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetJobUnlockCodeResult>(){

            @Override
            public GetJobUnlockCodeResult call() throws Exception {
                GetJobUnlockCodeResult result;
                try {
                    result = AmazonSnowballAsyncClient.this.getJobUnlockCode(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetSnowballUsageResult> getSnowballUsageAsync(GetSnowballUsageRequest request) {
        return this.getSnowballUsageAsync(request, null);
    }

    @Override
    public Future<GetSnowballUsageResult> getSnowballUsageAsync(final GetSnowballUsageRequest request, final AsyncHandler<GetSnowballUsageRequest, GetSnowballUsageResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetSnowballUsageResult>(){

            @Override
            public GetSnowballUsageResult call() throws Exception {
                GetSnowballUsageResult result;
                try {
                    result = AmazonSnowballAsyncClient.this.getSnowballUsage(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListJobsResult> listJobsAsync(ListJobsRequest request) {
        return this.listJobsAsync(request, null);
    }

    @Override
    public Future<ListJobsResult> listJobsAsync(final ListJobsRequest request, final AsyncHandler<ListJobsRequest, ListJobsResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListJobsResult>(){

            @Override
            public ListJobsResult call() throws Exception {
                ListJobsResult result;
                try {
                    result = AmazonSnowballAsyncClient.this.listJobs(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateJobResult> updateJobAsync(UpdateJobRequest request) {
        return this.updateJobAsync(request, null);
    }

    @Override
    public Future<UpdateJobResult> updateJobAsync(final UpdateJobRequest request, final AsyncHandler<UpdateJobRequest, UpdateJobResult> asyncHandler) {
        return this.executorService.submit(new Callable<UpdateJobResult>(){

            @Override
            public UpdateJobResult call() throws Exception {
                UpdateJobResult result;
                try {
                    result = AmazonSnowballAsyncClient.this.updateJob(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

