/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.DeleteVpcEndpointsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DeleteVpcEndpointsRequestMarshaller
implements Marshaller<Request<DeleteVpcEndpointsRequest>, DeleteVpcEndpointsRequest> {
    @Override
    public Request<DeleteVpcEndpointsRequest> marshall(DeleteVpcEndpointsRequest deleteVpcEndpointsRequest) {
        if (deleteVpcEndpointsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DeleteVpcEndpointsRequest> request = new DefaultRequest<DeleteVpcEndpointsRequest>(deleteVpcEndpointsRequest, "AmazonEC2");
        request.addParameter("Action", "DeleteVpcEndpoints");
        request.addParameter("Version", "2016-04-01");
        request.setHttpMethod(HttpMethodName.POST);
        SdkInternalList vpcEndpointIdsList = (SdkInternalList)deleteVpcEndpointsRequest.getVpcEndpointIds();
        if (!vpcEndpointIdsList.isEmpty() || !vpcEndpointIdsList.isAutoConstruct()) {
            int vpcEndpointIdsListIndex = 1;
            for (String vpcEndpointIdsListValue : vpcEndpointIdsList) {
                if (vpcEndpointIdsListValue != null) {
                    request.addParameter("VpcEndpointId." + vpcEndpointIdsListIndex, StringUtils.fromString(vpcEndpointIdsListValue));
                }
                ++vpcEndpointIdsListIndex;
            }
        }
        return request;
    }
}

