/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidp.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.cognitoidp.model.RespondToAuthChallengeRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.util.Map;

public class RespondToAuthChallengeRequestMarshaller
implements Marshaller<Request<RespondToAuthChallengeRequest>, RespondToAuthChallengeRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public RespondToAuthChallengeRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<RespondToAuthChallengeRequest> marshall(RespondToAuthChallengeRequest respondToAuthChallengeRequest) {
        if (respondToAuthChallengeRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<RespondToAuthChallengeRequest> request = new DefaultRequest<RespondToAuthChallengeRequest>(respondToAuthChallengeRequest, "AWSCognitoIdentityProvider");
        request.addHeader("X-Amz-Target", "AWSCognitoIdentityProviderService.RespondToAuthChallenge");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            Map<String, String> challengeResponsesMap;
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (respondToAuthChallengeRequest.getClientId() != null) {
                jsonGenerator.writeFieldName("ClientId").writeValue(respondToAuthChallengeRequest.getClientId());
            }
            if (respondToAuthChallengeRequest.getChallengeName() != null) {
                jsonGenerator.writeFieldName("ChallengeName").writeValue(respondToAuthChallengeRequest.getChallengeName());
            }
            if (respondToAuthChallengeRequest.getSession() != null) {
                jsonGenerator.writeFieldName("Session").writeValue(respondToAuthChallengeRequest.getSession());
            }
            if ((challengeResponsesMap = respondToAuthChallengeRequest.getChallengeResponses()) != null) {
                jsonGenerator.writeFieldName("ChallengeResponses");
                jsonGenerator.writeStartObject();
                for (Map.Entry<String, String> challengeResponsesMapValue : challengeResponsesMap.entrySet()) {
                    if (challengeResponsesMapValue.getValue() == null) continue;
                    jsonGenerator.writeFieldName(challengeResponsesMapValue.getKey());
                    jsonGenerator.writeValue(challengeResponsesMapValue.getValue());
                }
                jsonGenerator.writeEndObject();
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

