/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simplesystemsmanagement.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.simplesystemsmanagement.model.ResourceDataSyncItem;
import java.util.Date;

@SdkInternalApi
public class ResourceDataSyncItemMarshaller {
    private static final MarshallingInfo<String> SYNCNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SyncName").build();
    private static final MarshallingInfo<StructuredPojo> S3DESTINATION_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("S3Destination").build();
    private static final MarshallingInfo<Date> LASTSYNCTIME_BINDING = MarshallingInfo.builder(MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastSyncTime").build();
    private static final MarshallingInfo<Date> LASTSUCCESSFULSYNCTIME_BINDING = MarshallingInfo.builder(MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastSuccessfulSyncTime").build();
    private static final MarshallingInfo<String> LASTSTATUS_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastStatus").build();
    private static final MarshallingInfo<Date> SYNCCREATEDTIME_BINDING = MarshallingInfo.builder(MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SyncCreatedTime").build();
    private static final MarshallingInfo<String> LASTSYNCSTATUSMESSAGE_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastSyncStatusMessage").build();
    private static final ResourceDataSyncItemMarshaller instance = new ResourceDataSyncItemMarshaller();

    public static ResourceDataSyncItemMarshaller getInstance() {
        return instance;
    }

    public void marshall(ResourceDataSyncItem resourceDataSyncItem, ProtocolMarshaller protocolMarshaller) {
        if (resourceDataSyncItem == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(resourceDataSyncItem.getSyncName(), SYNCNAME_BINDING);
            protocolMarshaller.marshall(resourceDataSyncItem.getS3Destination(), S3DESTINATION_BINDING);
            protocolMarshaller.marshall(resourceDataSyncItem.getLastSyncTime(), LASTSYNCTIME_BINDING);
            protocolMarshaller.marshall(resourceDataSyncItem.getLastSuccessfulSyncTime(), LASTSUCCESSFULSYNCTIME_BINDING);
            protocolMarshaller.marshall(resourceDataSyncItem.getLastStatus(), LASTSTATUS_BINDING);
            protocolMarshaller.marshall(resourceDataSyncItem.getSyncCreatedTime(), SYNCCREATEDTIME_BINDING);
            protocolMarshaller.marshall(resourceDataSyncItem.getLastSyncStatusMessage(), LASTSYNCSTATUSMESSAGE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

