/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleemail.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.simpleemail.model.Destination;
import com.amazonaws.services.simpleemail.model.MessageTag;
import com.amazonaws.services.simpleemail.model.SendTemplatedEmailRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class SendTemplatedEmailRequestMarshaller
implements Marshaller<Request<SendTemplatedEmailRequest>, SendTemplatedEmailRequest> {
    @Override
    public Request<SendTemplatedEmailRequest> marshall(SendTemplatedEmailRequest sendTemplatedEmailRequest) {
        Destination destination;
        if (sendTemplatedEmailRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<SendTemplatedEmailRequest> request = new DefaultRequest<SendTemplatedEmailRequest>(sendTemplatedEmailRequest, "AmazonSimpleEmailService");
        request.addParameter("Action", "SendTemplatedEmail");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (sendTemplatedEmailRequest.getSource() != null) {
            request.addParameter("Source", StringUtils.fromString(sendTemplatedEmailRequest.getSource()));
        }
        if ((destination = sendTemplatedEmailRequest.getDestination()) != null) {
            if (!destination.getToAddresses().isEmpty() || !((SdkInternalList)destination.getToAddresses()).isAutoConstruct()) {
                SdkInternalList toAddressesList = (SdkInternalList)destination.getToAddresses();
                int toAddressesListIndex = 1;
                for (String toAddressesListValue : toAddressesList) {
                    if (toAddressesListValue != null) {
                        request.addParameter("Destination.ToAddresses.member." + toAddressesListIndex, StringUtils.fromString(toAddressesListValue));
                    }
                    ++toAddressesListIndex;
                }
            }
            if (!destination.getCcAddresses().isEmpty() || !((SdkInternalList)destination.getCcAddresses()).isAutoConstruct()) {
                SdkInternalList ccAddressesList = (SdkInternalList)destination.getCcAddresses();
                int ccAddressesListIndex = 1;
                for (String ccAddressesListValue : ccAddressesList) {
                    if (ccAddressesListValue != null) {
                        request.addParameter("Destination.CcAddresses.member." + ccAddressesListIndex, StringUtils.fromString(ccAddressesListValue));
                    }
                    ++ccAddressesListIndex;
                }
            }
            if (!destination.getBccAddresses().isEmpty() || !((SdkInternalList)destination.getBccAddresses()).isAutoConstruct()) {
                SdkInternalList bccAddressesList = (SdkInternalList)destination.getBccAddresses();
                int bccAddressesListIndex = 1;
                for (String bccAddressesListValue : bccAddressesList) {
                    if (bccAddressesListValue != null) {
                        request.addParameter("Destination.BccAddresses.member." + bccAddressesListIndex, StringUtils.fromString(bccAddressesListValue));
                    }
                    ++bccAddressesListIndex;
                }
            }
        }
        if (!sendTemplatedEmailRequest.getReplyToAddresses().isEmpty() || !((SdkInternalList)sendTemplatedEmailRequest.getReplyToAddresses()).isAutoConstruct()) {
            SdkInternalList replyToAddressesList = (SdkInternalList)sendTemplatedEmailRequest.getReplyToAddresses();
            int replyToAddressesListIndex = 1;
            for (String replyToAddressesListValue : replyToAddressesList) {
                if (replyToAddressesListValue != null) {
                    request.addParameter("ReplyToAddresses.member." + replyToAddressesListIndex, StringUtils.fromString(replyToAddressesListValue));
                }
                ++replyToAddressesListIndex;
            }
        }
        if (sendTemplatedEmailRequest.getReturnPath() != null) {
            request.addParameter("ReturnPath", StringUtils.fromString(sendTemplatedEmailRequest.getReturnPath()));
        }
        if (sendTemplatedEmailRequest.getSourceArn() != null) {
            request.addParameter("SourceArn", StringUtils.fromString(sendTemplatedEmailRequest.getSourceArn()));
        }
        if (sendTemplatedEmailRequest.getReturnPathArn() != null) {
            request.addParameter("ReturnPathArn", StringUtils.fromString(sendTemplatedEmailRequest.getReturnPathArn()));
        }
        if (!sendTemplatedEmailRequest.getTags().isEmpty() || !((SdkInternalList)sendTemplatedEmailRequest.getTags()).isAutoConstruct()) {
            SdkInternalList tagsList = (SdkInternalList)sendTemplatedEmailRequest.getTags();
            int tagsListIndex = 1;
            for (MessageTag tagsListValue : tagsList) {
                if (tagsListValue.getName() != null) {
                    request.addParameter("Tags.member." + tagsListIndex + ".Name", StringUtils.fromString(tagsListValue.getName()));
                }
                if (tagsListValue.getValue() != null) {
                    request.addParameter("Tags.member." + tagsListIndex + ".Value", StringUtils.fromString(tagsListValue.getValue()));
                }
                ++tagsListIndex;
            }
        }
        if (sendTemplatedEmailRequest.getConfigurationSetName() != null) {
            request.addParameter("ConfigurationSetName", StringUtils.fromString(sendTemplatedEmailRequest.getConfigurationSetName()));
        }
        if (sendTemplatedEmailRequest.getTemplate() != null) {
            request.addParameter("Template", StringUtils.fromString(sendTemplatedEmailRequest.getTemplate()));
        }
        if (sendTemplatedEmailRequest.getTemplateArn() != null) {
            request.addParameter("TemplateArn", StringUtils.fromString(sendTemplatedEmailRequest.getTemplateArn()));
        }
        if (sendTemplatedEmailRequest.getTemplateData() != null) {
            request.addParameter("TemplateData", StringUtils.fromString(sendTemplatedEmailRequest.getTemplateData()));
        }
        return request;
    }
}

