/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleemail.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.simpleemail.model.MessageTag;
import com.amazonaws.services.simpleemail.model.RawMessage;
import com.amazonaws.services.simpleemail.model.SendRawEmailRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class SendRawEmailRequestMarshaller
implements Marshaller<Request<SendRawEmailRequest>, SendRawEmailRequest> {
    @Override
    public Request<SendRawEmailRequest> marshall(SendRawEmailRequest sendRawEmailRequest) {
        RawMessage rawMessage;
        if (sendRawEmailRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<SendRawEmailRequest> request = new DefaultRequest<SendRawEmailRequest>(sendRawEmailRequest, "AmazonSimpleEmailService");
        request.addParameter("Action", "SendRawEmail");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (sendRawEmailRequest.getSource() != null) {
            request.addParameter("Source", StringUtils.fromString(sendRawEmailRequest.getSource()));
        }
        if (!sendRawEmailRequest.getDestinations().isEmpty() || !((SdkInternalList)sendRawEmailRequest.getDestinations()).isAutoConstruct()) {
            SdkInternalList destinationsList = (SdkInternalList)sendRawEmailRequest.getDestinations();
            int destinationsListIndex = 1;
            for (String destinationsListValue : destinationsList) {
                if (destinationsListValue != null) {
                    request.addParameter("Destinations.member." + destinationsListIndex, StringUtils.fromString(destinationsListValue));
                }
                ++destinationsListIndex;
            }
        }
        if ((rawMessage = sendRawEmailRequest.getRawMessage()) != null && rawMessage.getData() != null) {
            request.addParameter("RawMessage.Data", StringUtils.fromByteBuffer(rawMessage.getData()));
        }
        if (sendRawEmailRequest.getFromArn() != null) {
            request.addParameter("FromArn", StringUtils.fromString(sendRawEmailRequest.getFromArn()));
        }
        if (sendRawEmailRequest.getSourceArn() != null) {
            request.addParameter("SourceArn", StringUtils.fromString(sendRawEmailRequest.getSourceArn()));
        }
        if (sendRawEmailRequest.getReturnPathArn() != null) {
            request.addParameter("ReturnPathArn", StringUtils.fromString(sendRawEmailRequest.getReturnPathArn()));
        }
        if (!sendRawEmailRequest.getTags().isEmpty() || !((SdkInternalList)sendRawEmailRequest.getTags()).isAutoConstruct()) {
            SdkInternalList tagsList = (SdkInternalList)sendRawEmailRequest.getTags();
            int tagsListIndex = 1;
            for (MessageTag tagsListValue : tagsList) {
                if (tagsListValue.getName() != null) {
                    request.addParameter("Tags.member." + tagsListIndex + ".Name", StringUtils.fromString(tagsListValue.getName()));
                }
                if (tagsListValue.getValue() != null) {
                    request.addParameter("Tags.member." + tagsListIndex + ".Value", StringUtils.fromString(tagsListValue.getValue()));
                }
                ++tagsListIndex;
            }
        }
        if (sendRawEmailRequest.getConfigurationSetName() != null) {
            request.addParameter("ConfigurationSetName", StringUtils.fromString(sendRawEmailRequest.getConfigurationSetName()));
        }
        return request;
    }
}

