/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleemail.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.simpleemail.model.BulkEmailDestination;
import com.amazonaws.services.simpleemail.model.Destination;
import com.amazonaws.services.simpleemail.model.MessageTag;
import com.amazonaws.services.simpleemail.model.SendBulkTemplatedEmailRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class SendBulkTemplatedEmailRequestMarshaller
implements Marshaller<Request<SendBulkTemplatedEmailRequest>, SendBulkTemplatedEmailRequest> {
    @Override
    public Request<SendBulkTemplatedEmailRequest> marshall(SendBulkTemplatedEmailRequest sendBulkTemplatedEmailRequest) {
        if (sendBulkTemplatedEmailRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<SendBulkTemplatedEmailRequest> request = new DefaultRequest<SendBulkTemplatedEmailRequest>(sendBulkTemplatedEmailRequest, "AmazonSimpleEmailService");
        request.addParameter("Action", "SendBulkTemplatedEmail");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (sendBulkTemplatedEmailRequest.getSource() != null) {
            request.addParameter("Source", StringUtils.fromString(sendBulkTemplatedEmailRequest.getSource()));
        }
        if (sendBulkTemplatedEmailRequest.getSourceArn() != null) {
            request.addParameter("SourceArn", StringUtils.fromString(sendBulkTemplatedEmailRequest.getSourceArn()));
        }
        if (!sendBulkTemplatedEmailRequest.getReplyToAddresses().isEmpty() || !((SdkInternalList)sendBulkTemplatedEmailRequest.getReplyToAddresses()).isAutoConstruct()) {
            SdkInternalList replyToAddressesList = (SdkInternalList)sendBulkTemplatedEmailRequest.getReplyToAddresses();
            int replyToAddressesListIndex = 1;
            for (String replyToAddressesListValue : replyToAddressesList) {
                if (replyToAddressesListValue != null) {
                    request.addParameter("ReplyToAddresses.member." + replyToAddressesListIndex, StringUtils.fromString(replyToAddressesListValue));
                }
                ++replyToAddressesListIndex;
            }
        }
        if (sendBulkTemplatedEmailRequest.getReturnPath() != null) {
            request.addParameter("ReturnPath", StringUtils.fromString(sendBulkTemplatedEmailRequest.getReturnPath()));
        }
        if (sendBulkTemplatedEmailRequest.getReturnPathArn() != null) {
            request.addParameter("ReturnPathArn", StringUtils.fromString(sendBulkTemplatedEmailRequest.getReturnPathArn()));
        }
        if (sendBulkTemplatedEmailRequest.getConfigurationSetName() != null) {
            request.addParameter("ConfigurationSetName", StringUtils.fromString(sendBulkTemplatedEmailRequest.getConfigurationSetName()));
        }
        if (!sendBulkTemplatedEmailRequest.getDefaultTags().isEmpty() || !((SdkInternalList)sendBulkTemplatedEmailRequest.getDefaultTags()).isAutoConstruct()) {
            SdkInternalList defaultTagsList = (SdkInternalList)sendBulkTemplatedEmailRequest.getDefaultTags();
            int defaultTagsListIndex = 1;
            for (MessageTag defaultTagsListValue : defaultTagsList) {
                if (defaultTagsListValue.getName() != null) {
                    request.addParameter("DefaultTags.member." + defaultTagsListIndex + ".Name", StringUtils.fromString(defaultTagsListValue.getName()));
                }
                if (defaultTagsListValue.getValue() != null) {
                    request.addParameter("DefaultTags.member." + defaultTagsListIndex + ".Value", StringUtils.fromString(defaultTagsListValue.getValue()));
                }
                ++defaultTagsListIndex;
            }
        }
        if (sendBulkTemplatedEmailRequest.getTemplate() != null) {
            request.addParameter("Template", StringUtils.fromString(sendBulkTemplatedEmailRequest.getTemplate()));
        }
        if (sendBulkTemplatedEmailRequest.getTemplateArn() != null) {
            request.addParameter("TemplateArn", StringUtils.fromString(sendBulkTemplatedEmailRequest.getTemplateArn()));
        }
        if (sendBulkTemplatedEmailRequest.getDefaultTemplateData() != null) {
            request.addParameter("DefaultTemplateData", StringUtils.fromString(sendBulkTemplatedEmailRequest.getDefaultTemplateData()));
        }
        if (!sendBulkTemplatedEmailRequest.getDestinations().isEmpty() || !((SdkInternalList)sendBulkTemplatedEmailRequest.getDestinations()).isAutoConstruct()) {
            SdkInternalList destinationsList = (SdkInternalList)sendBulkTemplatedEmailRequest.getDestinations();
            int destinationsListIndex = 1;
            for (BulkEmailDestination destinationsListValue : destinationsList) {
                Destination destination = destinationsListValue.getDestination();
                if (destination != null) {
                    if (!destination.getToAddresses().isEmpty() || !((SdkInternalList)destination.getToAddresses()).isAutoConstruct()) {
                        SdkInternalList toAddressesList = (SdkInternalList)destination.getToAddresses();
                        int toAddressesListIndex = 1;
                        for (String toAddressesListValue : toAddressesList) {
                            if (toAddressesListValue != null) {
                                request.addParameter("Destinations.member." + destinationsListIndex + ".Destination.ToAddresses.member." + toAddressesListIndex, StringUtils.fromString(toAddressesListValue));
                            }
                            ++toAddressesListIndex;
                        }
                    }
                    if (!destination.getCcAddresses().isEmpty() || !((SdkInternalList)destination.getCcAddresses()).isAutoConstruct()) {
                        SdkInternalList ccAddressesList = (SdkInternalList)destination.getCcAddresses();
                        int ccAddressesListIndex = 1;
                        for (String ccAddressesListValue : ccAddressesList) {
                            if (ccAddressesListValue != null) {
                                request.addParameter("Destinations.member." + destinationsListIndex + ".Destination.CcAddresses.member." + ccAddressesListIndex, StringUtils.fromString(ccAddressesListValue));
                            }
                            ++ccAddressesListIndex;
                        }
                    }
                    if (!destination.getBccAddresses().isEmpty() || !((SdkInternalList)destination.getBccAddresses()).isAutoConstruct()) {
                        SdkInternalList bccAddressesList = (SdkInternalList)destination.getBccAddresses();
                        int bccAddressesListIndex = 1;
                        for (String bccAddressesListValue : bccAddressesList) {
                            if (bccAddressesListValue != null) {
                                request.addParameter("Destinations.member." + destinationsListIndex + ".Destination.BccAddresses.member." + bccAddressesListIndex, StringUtils.fromString(bccAddressesListValue));
                            }
                            ++bccAddressesListIndex;
                        }
                    }
                }
                if (!destinationsListValue.getReplacementTags().isEmpty() || !((SdkInternalList)destinationsListValue.getReplacementTags()).isAutoConstruct()) {
                    SdkInternalList replacementTagsList = (SdkInternalList)destinationsListValue.getReplacementTags();
                    int replacementTagsListIndex = 1;
                    for (MessageTag replacementTagsListValue : replacementTagsList) {
                        if (replacementTagsListValue.getName() != null) {
                            request.addParameter("Destinations.member." + destinationsListIndex + ".ReplacementTags.member." + replacementTagsListIndex + ".Name", StringUtils.fromString(replacementTagsListValue.getName()));
                        }
                        if (replacementTagsListValue.getValue() != null) {
                            request.addParameter("Destinations.member." + destinationsListIndex + ".ReplacementTags.member." + replacementTagsListIndex + ".Value", StringUtils.fromString(replacementTagsListValue.getValue()));
                        }
                        ++replacementTagsListIndex;
                    }
                }
                if (destinationsListValue.getReplacementTemplateData() != null) {
                    request.addParameter("Destinations.member." + destinationsListIndex + ".ReplacementTemplateData", StringUtils.fromString(destinationsListValue.getReplacementTemplateData()));
                }
                ++destinationsListIndex;
            }
        }
        return request;
    }
}

