/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpledb.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.simpledb.model.GetAttributesRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class GetAttributesRequestMarshaller
implements Marshaller<Request<GetAttributesRequest>, GetAttributesRequest> {
    @Override
    public Request<GetAttributesRequest> marshall(GetAttributesRequest getAttributesRequest) {
        if (getAttributesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<GetAttributesRequest> request = new DefaultRequest<GetAttributesRequest>(getAttributesRequest, "AmazonSimpleDB");
        request.addParameter("Action", "GetAttributes");
        request.addParameter("Version", "2009-04-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (getAttributesRequest.getDomainName() != null) {
            request.addParameter("DomainName", StringUtils.fromString(getAttributesRequest.getDomainName()));
        }
        if (getAttributesRequest.getItemName() != null) {
            request.addParameter("ItemName", StringUtils.fromString(getAttributesRequest.getItemName()));
        }
        if (!getAttributesRequest.getAttributeNames().isEmpty() || !((SdkInternalList)getAttributesRequest.getAttributeNames()).isAutoConstruct()) {
            SdkInternalList attributeNamesList = (SdkInternalList)getAttributesRequest.getAttributeNames();
            int attributeNamesListIndex = 1;
            for (String attributeNamesListValue : attributeNamesList) {
                if (attributeNamesListValue != null) {
                    request.addParameter("AttributeName." + attributeNamesListIndex, StringUtils.fromString(attributeNamesListValue));
                }
                ++attributeNamesListIndex;
            }
        }
        if (getAttributesRequest.getConsistentRead() != null) {
            request.addParameter("ConsistentRead", StringUtils.fromBoolean(getAttributesRequest.getConsistentRead()));
        }
        return request;
    }
}

