/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.servicediscovery.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.servicediscovery.model.DnsConfig;
import java.util.List;

@SdkInternalApi
public class DnsConfigMarshaller {
    private static final MarshallingInfo<String> NAMESPACEID_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NamespaceId").build();
    private static final MarshallingInfo<String> ROUTINGPOLICY_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RoutingPolicy").build();
    private static final MarshallingInfo<List> DNSRECORDS_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DnsRecords").build();
    private static final DnsConfigMarshaller instance = new DnsConfigMarshaller();

    public static DnsConfigMarshaller getInstance() {
        return instance;
    }

    public void marshall(DnsConfig dnsConfig, ProtocolMarshaller protocolMarshaller) {
        if (dnsConfig == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(dnsConfig.getNamespaceId(), NAMESPACEID_BINDING);
            protocolMarshaller.marshall(dnsConfig.getRoutingPolicy(), ROUTINGPOLICY_BINDING);
            protocolMarshaller.marshall(dnsConfig.getDnsRecords(), DNSRECORDS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

