/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.servicediscovery.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.servicediscovery.model.DnsRecord;
import com.amazonaws.services.servicediscovery.model.RoutingPolicy;
import com.amazonaws.services.servicediscovery.model.transform.DnsConfigMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DnsConfig
implements Serializable,
Cloneable,
StructuredPojo {
    private String namespaceId;
    private String routingPolicy;
    private List<DnsRecord> dnsRecords;

    public void setNamespaceId(String namespaceId) {
        this.namespaceId = namespaceId;
    }

    public String getNamespaceId() {
        return this.namespaceId;
    }

    public DnsConfig withNamespaceId(String namespaceId) {
        this.setNamespaceId(namespaceId);
        return this;
    }

    public void setRoutingPolicy(String routingPolicy) {
        this.routingPolicy = routingPolicy;
    }

    public String getRoutingPolicy() {
        return this.routingPolicy;
    }

    public DnsConfig withRoutingPolicy(String routingPolicy) {
        this.setRoutingPolicy(routingPolicy);
        return this;
    }

    public DnsConfig withRoutingPolicy(RoutingPolicy routingPolicy) {
        this.routingPolicy = routingPolicy.toString();
        return this;
    }

    public List<DnsRecord> getDnsRecords() {
        return this.dnsRecords;
    }

    public void setDnsRecords(Collection<DnsRecord> dnsRecords) {
        if (dnsRecords == null) {
            this.dnsRecords = null;
            return;
        }
        this.dnsRecords = new ArrayList<DnsRecord>(dnsRecords);
    }

    public DnsConfig withDnsRecords(DnsRecord ... dnsRecords) {
        if (this.dnsRecords == null) {
            this.setDnsRecords(new ArrayList<DnsRecord>(dnsRecords.length));
        }
        for (DnsRecord ele : dnsRecords) {
            this.dnsRecords.add(ele);
        }
        return this;
    }

    public DnsConfig withDnsRecords(Collection<DnsRecord> dnsRecords) {
        this.setDnsRecords(dnsRecords);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getNamespaceId() != null) {
            sb.append("NamespaceId: ").append(this.getNamespaceId()).append(",");
        }
        if (this.getRoutingPolicy() != null) {
            sb.append("RoutingPolicy: ").append(this.getRoutingPolicy()).append(",");
        }
        if (this.getDnsRecords() != null) {
            sb.append("DnsRecords: ").append(this.getDnsRecords());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DnsConfig)) {
            return false;
        }
        DnsConfig other = (DnsConfig)obj;
        if (other.getNamespaceId() == null ^ this.getNamespaceId() == null) {
            return false;
        }
        if (other.getNamespaceId() != null && !other.getNamespaceId().equals(this.getNamespaceId())) {
            return false;
        }
        if (other.getRoutingPolicy() == null ^ this.getRoutingPolicy() == null) {
            return false;
        }
        if (other.getRoutingPolicy() != null && !other.getRoutingPolicy().equals(this.getRoutingPolicy())) {
            return false;
        }
        if (other.getDnsRecords() == null ^ this.getDnsRecords() == null) {
            return false;
        }
        return other.getDnsRecords() == null || other.getDnsRecords().equals(this.getDnsRecords());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getNamespaceId() == null ? 0 : this.getNamespaceId().hashCode());
        hashCode = 31 * hashCode + (this.getRoutingPolicy() == null ? 0 : this.getRoutingPolicy().hashCode());
        hashCode = 31 * hashCode + (this.getDnsRecords() == null ? 0 : this.getDnsRecords().hashCode());
        return hashCode;
    }

    public DnsConfig clone() {
        try {
            return (DnsConfig)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DnsConfigMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

