/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemaker.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.sagemaker.model.AlgorithmSpecification;

@SdkInternalApi
public class AlgorithmSpecificationMarshaller {
    private static final MarshallingInfo<String> TRAININGIMAGE_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TrainingImage").build();
    private static final MarshallingInfo<String> TRAININGINPUTMODE_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TrainingInputMode").build();
    private static final AlgorithmSpecificationMarshaller instance = new AlgorithmSpecificationMarshaller();

    public static AlgorithmSpecificationMarshaller getInstance() {
        return instance;
    }

    public void marshall(AlgorithmSpecification algorithmSpecification, ProtocolMarshaller protocolMarshaller) {
        if (algorithmSpecification == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(algorithmSpecification.getTrainingImage(), TRAININGIMAGE_BINDING);
            protocolMarshaller.marshall(algorithmSpecification.getTrainingInputMode(), TRAININGINPUTMODE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

