/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.redshift.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.redshift.model.DescribeHsmConfigurationsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DescribeHsmConfigurationsRequestMarshaller
implements Marshaller<Request<DescribeHsmConfigurationsRequest>, DescribeHsmConfigurationsRequest> {
    @Override
    public Request<DescribeHsmConfigurationsRequest> marshall(DescribeHsmConfigurationsRequest describeHsmConfigurationsRequest) {
        if (describeHsmConfigurationsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribeHsmConfigurationsRequest> request = new DefaultRequest<DescribeHsmConfigurationsRequest>(describeHsmConfigurationsRequest, "AmazonRedshift");
        request.addParameter("Action", "DescribeHsmConfigurations");
        request.addParameter("Version", "2012-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeHsmConfigurationsRequest.getHsmConfigurationIdentifier() != null) {
            request.addParameter("HsmConfigurationIdentifier", StringUtils.fromString(describeHsmConfigurationsRequest.getHsmConfigurationIdentifier()));
        }
        if (describeHsmConfigurationsRequest.getMaxRecords() != null) {
            request.addParameter("MaxRecords", StringUtils.fromInteger(describeHsmConfigurationsRequest.getMaxRecords()));
        }
        if (describeHsmConfigurationsRequest.getMarker() != null) {
            request.addParameter("Marker", StringUtils.fromString(describeHsmConfigurationsRequest.getMarker()));
        }
        if (!describeHsmConfigurationsRequest.getTagKeys().isEmpty() || !((SdkInternalList)describeHsmConfigurationsRequest.getTagKeys()).isAutoConstruct()) {
            SdkInternalList tagKeysList = (SdkInternalList)describeHsmConfigurationsRequest.getTagKeys();
            int tagKeysListIndex = 1;
            for (String tagKeysListValue : tagKeysList) {
                if (tagKeysListValue != null) {
                    request.addParameter("TagKeys.TagKey." + tagKeysListIndex, StringUtils.fromString(tagKeysListValue));
                }
                ++tagKeysListIndex;
            }
        }
        if (!describeHsmConfigurationsRequest.getTagValues().isEmpty() || !((SdkInternalList)describeHsmConfigurationsRequest.getTagValues()).isAutoConstruct()) {
            SdkInternalList tagValuesList = (SdkInternalList)describeHsmConfigurationsRequest.getTagValues();
            int tagValuesListIndex = 1;
            for (String tagValuesListValue : tagValuesList) {
                if (tagValuesListValue != null) {
                    request.addParameter("TagValues.TagValue." + tagValuesListIndex, StringUtils.fromString(tagValuesListValue));
                }
                ++tagValuesListIndex;
            }
        }
        return request;
    }
}

