/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.redshift.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.redshift.model.DescribeHsmClientCertificatesRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DescribeHsmClientCertificatesRequestMarshaller
implements Marshaller<Request<DescribeHsmClientCertificatesRequest>, DescribeHsmClientCertificatesRequest> {
    @Override
    public Request<DescribeHsmClientCertificatesRequest> marshall(DescribeHsmClientCertificatesRequest describeHsmClientCertificatesRequest) {
        if (describeHsmClientCertificatesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribeHsmClientCertificatesRequest> request = new DefaultRequest<DescribeHsmClientCertificatesRequest>(describeHsmClientCertificatesRequest, "AmazonRedshift");
        request.addParameter("Action", "DescribeHsmClientCertificates");
        request.addParameter("Version", "2012-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeHsmClientCertificatesRequest.getHsmClientCertificateIdentifier() != null) {
            request.addParameter("HsmClientCertificateIdentifier", StringUtils.fromString(describeHsmClientCertificatesRequest.getHsmClientCertificateIdentifier()));
        }
        if (describeHsmClientCertificatesRequest.getMaxRecords() != null) {
            request.addParameter("MaxRecords", StringUtils.fromInteger(describeHsmClientCertificatesRequest.getMaxRecords()));
        }
        if (describeHsmClientCertificatesRequest.getMarker() != null) {
            request.addParameter("Marker", StringUtils.fromString(describeHsmClientCertificatesRequest.getMarker()));
        }
        if (!describeHsmClientCertificatesRequest.getTagKeys().isEmpty() || !((SdkInternalList)describeHsmClientCertificatesRequest.getTagKeys()).isAutoConstruct()) {
            SdkInternalList tagKeysList = (SdkInternalList)describeHsmClientCertificatesRequest.getTagKeys();
            int tagKeysListIndex = 1;
            for (String tagKeysListValue : tagKeysList) {
                if (tagKeysListValue != null) {
                    request.addParameter("TagKeys.TagKey." + tagKeysListIndex, StringUtils.fromString(tagKeysListValue));
                }
                ++tagKeysListIndex;
            }
        }
        if (!describeHsmClientCertificatesRequest.getTagValues().isEmpty() || !((SdkInternalList)describeHsmClientCertificatesRequest.getTagValues()).isAutoConstruct()) {
            SdkInternalList tagValuesList = (SdkInternalList)describeHsmClientCertificatesRequest.getTagValues();
            int tagValuesListIndex = 1;
            for (String tagValuesListValue : tagValuesList) {
                if (tagValuesListValue != null) {
                    request.addParameter("TagValues.TagValue." + tagValuesListIndex, StringUtils.fromString(tagValuesListValue));
                }
                ++tagValuesListIndex;
            }
        }
        return request;
    }
}

