/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rds.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.rds.model.ModifyDBParameterGroupRequest;
import com.amazonaws.services.rds.model.Parameter;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class ModifyDBParameterGroupRequestMarshaller
implements Marshaller<Request<ModifyDBParameterGroupRequest>, ModifyDBParameterGroupRequest> {
    @Override
    public Request<ModifyDBParameterGroupRequest> marshall(ModifyDBParameterGroupRequest modifyDBParameterGroupRequest) {
        if (modifyDBParameterGroupRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ModifyDBParameterGroupRequest> request = new DefaultRequest<ModifyDBParameterGroupRequest>(modifyDBParameterGroupRequest, "AmazonRDS");
        request.addParameter("Action", "ModifyDBParameterGroup");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (modifyDBParameterGroupRequest.getDBParameterGroupName() != null) {
            request.addParameter("DBParameterGroupName", StringUtils.fromString(modifyDBParameterGroupRequest.getDBParameterGroupName()));
        }
        if (!modifyDBParameterGroupRequest.getParameters().isEmpty() || !((SdkInternalList)modifyDBParameterGroupRequest.getParameters()).isAutoConstruct()) {
            SdkInternalList parametersList = (SdkInternalList)modifyDBParameterGroupRequest.getParameters();
            int parametersListIndex = 1;
            for (Parameter parametersListValue : parametersList) {
                if (parametersListValue.getParameterName() != null) {
                    request.addParameter("Parameters.Parameter." + parametersListIndex + ".ParameterName", StringUtils.fromString(parametersListValue.getParameterName()));
                }
                if (parametersListValue.getParameterValue() != null) {
                    request.addParameter("Parameters.Parameter." + parametersListIndex + ".ParameterValue", StringUtils.fromString(parametersListValue.getParameterValue()));
                }
                if (parametersListValue.getDescription() != null) {
                    request.addParameter("Parameters.Parameter." + parametersListIndex + ".Description", StringUtils.fromString(parametersListValue.getDescription()));
                }
                if (parametersListValue.getSource() != null) {
                    request.addParameter("Parameters.Parameter." + parametersListIndex + ".Source", StringUtils.fromString(parametersListValue.getSource()));
                }
                if (parametersListValue.getApplyType() != null) {
                    request.addParameter("Parameters.Parameter." + parametersListIndex + ".ApplyType", StringUtils.fromString(parametersListValue.getApplyType()));
                }
                if (parametersListValue.getDataType() != null) {
                    request.addParameter("Parameters.Parameter." + parametersListIndex + ".DataType", StringUtils.fromString(parametersListValue.getDataType()));
                }
                if (parametersListValue.getAllowedValues() != null) {
                    request.addParameter("Parameters.Parameter." + parametersListIndex + ".AllowedValues", StringUtils.fromString(parametersListValue.getAllowedValues()));
                }
                if (parametersListValue.getIsModifiable() != null) {
                    request.addParameter("Parameters.Parameter." + parametersListIndex + ".IsModifiable", StringUtils.fromBoolean(parametersListValue.getIsModifiable()));
                }
                if (parametersListValue.getMinimumEngineVersion() != null) {
                    request.addParameter("Parameters.Parameter." + parametersListIndex + ".MinimumEngineVersion", StringUtils.fromString(parametersListValue.getMinimumEngineVersion()));
                }
                if (parametersListValue.getApplyMethod() != null) {
                    request.addParameter("Parameters.Parameter." + parametersListIndex + ".ApplyMethod", StringUtils.fromString(parametersListValue.getApplyMethod()));
                }
                ++parametersListIndex;
            }
        }
        return request;
    }
}

