/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rds.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.rds.model.CreateDBClusterRequest;
import com.amazonaws.services.rds.model.Tag;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class CreateDBClusterRequestMarshaller
implements Marshaller<Request<CreateDBClusterRequest>, CreateDBClusterRequest> {
    @Override
    public Request<CreateDBClusterRequest> marshall(CreateDBClusterRequest createDBClusterRequest) {
        if (createDBClusterRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateDBClusterRequest> request = new DefaultRequest<CreateDBClusterRequest>(createDBClusterRequest, "AmazonRDS");
        request.addParameter("Action", "CreateDBCluster");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (!createDBClusterRequest.getAvailabilityZones().isEmpty() || !((SdkInternalList)createDBClusterRequest.getAvailabilityZones()).isAutoConstruct()) {
            SdkInternalList availabilityZonesList = (SdkInternalList)createDBClusterRequest.getAvailabilityZones();
            int availabilityZonesListIndex = 1;
            for (String availabilityZonesListValue : availabilityZonesList) {
                if (availabilityZonesListValue != null) {
                    request.addParameter("AvailabilityZones.AvailabilityZone." + availabilityZonesListIndex, StringUtils.fromString(availabilityZonesListValue));
                }
                ++availabilityZonesListIndex;
            }
        }
        if (createDBClusterRequest.getBackupRetentionPeriod() != null) {
            request.addParameter("BackupRetentionPeriod", StringUtils.fromInteger(createDBClusterRequest.getBackupRetentionPeriod()));
        }
        if (createDBClusterRequest.getCharacterSetName() != null) {
            request.addParameter("CharacterSetName", StringUtils.fromString(createDBClusterRequest.getCharacterSetName()));
        }
        if (createDBClusterRequest.getDatabaseName() != null) {
            request.addParameter("DatabaseName", StringUtils.fromString(createDBClusterRequest.getDatabaseName()));
        }
        if (createDBClusterRequest.getDBClusterIdentifier() != null) {
            request.addParameter("DBClusterIdentifier", StringUtils.fromString(createDBClusterRequest.getDBClusterIdentifier()));
        }
        if (createDBClusterRequest.getDBClusterParameterGroupName() != null) {
            request.addParameter("DBClusterParameterGroupName", StringUtils.fromString(createDBClusterRequest.getDBClusterParameterGroupName()));
        }
        if (!createDBClusterRequest.getVpcSecurityGroupIds().isEmpty() || !((SdkInternalList)createDBClusterRequest.getVpcSecurityGroupIds()).isAutoConstruct()) {
            SdkInternalList vpcSecurityGroupIdsList = (SdkInternalList)createDBClusterRequest.getVpcSecurityGroupIds();
            int vpcSecurityGroupIdsListIndex = 1;
            for (String vpcSecurityGroupIdsListValue : vpcSecurityGroupIdsList) {
                if (vpcSecurityGroupIdsListValue != null) {
                    request.addParameter("VpcSecurityGroupIds.VpcSecurityGroupId." + vpcSecurityGroupIdsListIndex, StringUtils.fromString(vpcSecurityGroupIdsListValue));
                }
                ++vpcSecurityGroupIdsListIndex;
            }
        }
        if (createDBClusterRequest.getDBSubnetGroupName() != null) {
            request.addParameter("DBSubnetGroupName", StringUtils.fromString(createDBClusterRequest.getDBSubnetGroupName()));
        }
        if (createDBClusterRequest.getEngine() != null) {
            request.addParameter("Engine", StringUtils.fromString(createDBClusterRequest.getEngine()));
        }
        if (createDBClusterRequest.getEngineVersion() != null) {
            request.addParameter("EngineVersion", StringUtils.fromString(createDBClusterRequest.getEngineVersion()));
        }
        if (createDBClusterRequest.getPort() != null) {
            request.addParameter("Port", StringUtils.fromInteger(createDBClusterRequest.getPort()));
        }
        if (createDBClusterRequest.getMasterUsername() != null) {
            request.addParameter("MasterUsername", StringUtils.fromString(createDBClusterRequest.getMasterUsername()));
        }
        if (createDBClusterRequest.getMasterUserPassword() != null) {
            request.addParameter("MasterUserPassword", StringUtils.fromString(createDBClusterRequest.getMasterUserPassword()));
        }
        if (createDBClusterRequest.getOptionGroupName() != null) {
            request.addParameter("OptionGroupName", StringUtils.fromString(createDBClusterRequest.getOptionGroupName()));
        }
        if (createDBClusterRequest.getPreferredBackupWindow() != null) {
            request.addParameter("PreferredBackupWindow", StringUtils.fromString(createDBClusterRequest.getPreferredBackupWindow()));
        }
        if (createDBClusterRequest.getPreferredMaintenanceWindow() != null) {
            request.addParameter("PreferredMaintenanceWindow", StringUtils.fromString(createDBClusterRequest.getPreferredMaintenanceWindow()));
        }
        if (createDBClusterRequest.getReplicationSourceIdentifier() != null) {
            request.addParameter("ReplicationSourceIdentifier", StringUtils.fromString(createDBClusterRequest.getReplicationSourceIdentifier()));
        }
        if (!createDBClusterRequest.getTags().isEmpty() || !((SdkInternalList)createDBClusterRequest.getTags()).isAutoConstruct()) {
            SdkInternalList tagsList = (SdkInternalList)createDBClusterRequest.getTags();
            int tagsListIndex = 1;
            for (Tag tagsListValue : tagsList) {
                if (tagsListValue.getKey() != null) {
                    request.addParameter("Tags.Tag." + tagsListIndex + ".Key", StringUtils.fromString(tagsListValue.getKey()));
                }
                if (tagsListValue.getValue() != null) {
                    request.addParameter("Tags.Tag." + tagsListIndex + ".Value", StringUtils.fromString(tagsListValue.getValue()));
                }
                ++tagsListIndex;
            }
        }
        if (createDBClusterRequest.getStorageEncrypted() != null) {
            request.addParameter("StorageEncrypted", StringUtils.fromBoolean(createDBClusterRequest.getStorageEncrypted()));
        }
        if (createDBClusterRequest.getKmsKeyId() != null) {
            request.addParameter("KmsKeyId", StringUtils.fromString(createDBClusterRequest.getKmsKeyId()));
        }
        if (createDBClusterRequest.getPreSignedUrl() != null) {
            request.addParameter("PreSignedUrl", StringUtils.fromString(createDBClusterRequest.getPreSignedUrl()));
        }
        if (createDBClusterRequest.getEnableIAMDatabaseAuthentication() != null) {
            request.addParameter("EnableIAMDatabaseAuthentication", StringUtils.fromBoolean(createDBClusterRequest.getEnableIAMDatabaseAuthentication()));
        }
        if (createDBClusterRequest.getSourceRegion() != null) {
            request.addParameter("SourceRegion", StringUtils.fromString(createDBClusterRequest.getSourceRegion()));
        }
        return request;
    }
}

