/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.mediaconvert.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.mediaconvert.model.RemixSettings;

@SdkInternalApi
public class RemixSettingsMarshaller {
    private static final MarshallingInfo<StructuredPojo> CHANNELMAPPING_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("channelMapping").build();
    private static final MarshallingInfo<Integer> CHANNELSIN_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("channelsIn").build();
    private static final MarshallingInfo<Integer> CHANNELSOUT_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("channelsOut").build();
    private static final RemixSettingsMarshaller instance = new RemixSettingsMarshaller();

    public static RemixSettingsMarshaller getInstance() {
        return instance;
    }

    public void marshall(RemixSettings remixSettings, ProtocolMarshaller protocolMarshaller) {
        if (remixSettings == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(remixSettings.getChannelMapping(), CHANNELMAPPING_BINDING);
            protocolMarshaller.marshall(remixSettings.getChannelsIn(), CHANNELSIN_BINDING);
            protocolMarshaller.marshall(remixSettings.getChannelsOut(), CHANNELSOUT_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

